/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.CDataNode;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.HtmlTreeBuilderState;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.TokeniserState;
import org.jsoup.parser.TreeBuilder;

public class HtmlTreeBuilder
extends TreeBuilder {
    static final String[] TagsSearchInScope = new String[]{"applet", "caption", "html", "marquee", "object", "table", "td", "th"};
    static final String[] TagSearchList = new String[]{"ol", "ul"};
    static final String[] TagSearchButton = new String[]{"button"};
    static final String[] TagSearchTableScope = new String[]{"html", "table"};
    static final String[] TagSearchSelectScope = new String[]{"optgroup", "option"};
    static final String[] TagSearchEndTags = new String[]{"dd", "dt", "li", "optgroup", "option", "p", "rb", "rp", "rt", "rtc"};
    static final String[] TagThoroughSearchEndTags = new String[]{"caption", "colgroup", "dd", "dt", "li", "optgroup", "option", "p", "rb", "rp", "rt", "rtc", "tbody", "td", "tfoot", "th", "thead", "tr"};
    static final String[] TagSearchSpecial = new String[]{"address", "applet", "area", "article", "aside", "base", "basefont", "bgsound", "blockquote", "body", "br", "button", "caption", "center", "col", "colgroup", "command", "dd", "details", "dir", "div", "dl", "dt", "embed", "fieldset", "figcaption", "figure", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "iframe", "img", "input", "isindex", "li", "link", "listing", "marquee", "menu", "meta", "nav", "noembed", "noframes", "noscript", "object", "ol", "p", "param", "plaintext", "pre", "script", "section", "select", "style", "summary", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "ul", "wbr", "xmp"};
    public static final int MaxScopeSearchDepth = 100;
    private HtmlTreeBuilderState state;
    private HtmlTreeBuilderState originalState;
    private boolean baseUriSetFromDoc;
    @Nullable
    private Element headElement;
    @Nullable
    private FormElement formElement;
    @Nullable
    private Element contextElement;
    private ArrayList<Element> formattingElements;
    private ArrayList<HtmlTreeBuilderState> tmplInsertMode;
    private List<String> pendingTableCharacters;
    private Token.EndTag emptyEnd;
    private boolean framesetOk;
    private boolean fosterInserts;
    private boolean fragmentParsing;
    private static final int maxQueueDepth = 256;
    private String[] specificScopeTarget = new String[]{null};
    private static final int maxUsedFormattingElements = 12;

    @Override
    ParseSettings defaultSettings() {
        return ParseSettings.htmlDefault;
    }

    @Override
    HtmlTreeBuilder newInstance() {
        return new HtmlTreeBuilder();
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void initialiseParse(Reader reader, String string, Parser parser) {
        super.initialiseParse(reader, string, parser);
        this.state = HtmlTreeBuilderState.Initial;
        this.originalState = null;
        this.baseUriSetFromDoc = false;
        this.headElement = null;
        this.formElement = null;
        this.contextElement = null;
        this.formattingElements = new ArrayList();
        this.tmplInsertMode = new ArrayList();
        this.pendingTableCharacters = new ArrayList<String>();
        this.emptyEnd = new Token.EndTag();
        this.framesetOk = true;
        this.fosterInserts = false;
        this.fragmentParsing = false;
    }

    @Override
    List<Node> parseFragment(String string, @Nullable Element element, String string2, Parser parser) {
        List<Node> list;
        this.state = HtmlTreeBuilderState.Initial;
        this.initialiseParse(new StringReader(string), string2, parser);
        this.contextElement = element;
        this.fragmentParsing = true;
        Node node = null;
        if (element != null) {
            if (element.ownerDocument() != null) {
                this.doc.quirksMode(element.ownerDocument().quirksMode());
            }
            switch (list = element.normalName()) {
                case "title": 
                case "textarea": {
                    this.tokeniser.transition(TokeniserState.Rcdata);
                    break;
                }
                case "iframe": 
                case "noembed": 
                case "noframes": 
                case "style": 
                case "xml": {
                    this.tokeniser.transition(TokeniserState.Rawtext);
                    break;
                }
                case "script": {
                    this.tokeniser.transition(TokeniserState.ScriptData);
                    break;
                }
                case "noscript": {
                    this.tokeniser.transition(TokeniserState.Data);
                    break;
                }
                case "plaintext": {
                    this.tokeniser.transition(TokeniserState.PLAINTEXT);
                    break;
                }
                case "template": {
                    this.tokeniser.transition(TokeniserState.Data);
                    this.pushTemplateMode(HtmlTreeBuilderState.InTemplate);
                    break;
                }
                default: {
                    this.tokeniser.transition(TokeniserState.Data);
                }
            }
            node = new Element(this.tagFor((String)((Object)list), this.settings), string2);
            this.doc.appendChild(node);
            this.stack.add(node);
            this.resetInsertionMode();
            for (Object object = element; object != null; object = ((Element)object).parent()) {
                if (!(object instanceof FormElement)) continue;
                this.formElement = (FormElement)object;
                break;
            }
        }
        this.runParser();
        if (element != null) {
            list = node.siblingNodes();
            if (!list.isEmpty()) {
                ((Element)node).insertChildren(-1, (Collection<? extends Node>)list);
            }
            return node.childNodes();
        }
        return this.doc.childNodes();
    }

    @Override
    protected boolean process(Token token) {
        this.currentToken = token;
        return this.state.process(token, this);
    }

    boolean process(Token token, HtmlTreeBuilderState htmlTreeBuilderState) {
        this.currentToken = token;
        return htmlTreeBuilderState.process(token, this);
    }

    void transition(HtmlTreeBuilderState htmlTreeBuilderState) {
        this.state = htmlTreeBuilderState;
    }

    HtmlTreeBuilderState state() {
        return this.state;
    }

    void markInsertionMode() {
        this.originalState = this.state;
    }

    HtmlTreeBuilderState originalState() {
        return this.originalState;
    }

    void framesetOk(boolean bl) {
        this.framesetOk = bl;
    }

    boolean framesetOk() {
        return this.framesetOk;
    }

    Document getDocument() {
        return this.doc;
    }

    String getBaseUri() {
        return this.baseUri;
    }

    void maybeSetBaseUri(Element element) {
        if (this.baseUriSetFromDoc) {
            return;
        }
        String string = element.absUrl("href");
        if (string.length() != 0) {
            this.baseUri = string;
            this.baseUriSetFromDoc = true;
            this.doc.setBaseUri(string);
        }
    }

    boolean isFragmentParsing() {
        return this.fragmentParsing;
    }

    void error(HtmlTreeBuilderState htmlTreeBuilderState) {
        if (this.parser.getErrors().canAddError()) {
            this.parser.getErrors().add(new ParseError(this.reader, "Unexpected %s token [%s] when in state [%s]", new Object[]{this.currentToken.tokenType(), this.currentToken, htmlTreeBuilderState}));
        }
    }

    Element insert(Token.StartTag startTag) {
        int n;
        if (startTag.hasAttributes() && !startTag.attributes.isEmpty() && (n = startTag.attributes.deduplicate(this.settings)) > 0) {
            this.error("Dropped duplicate attribute(s) in tag [%s]", startTag.normalName);
        }
        if (startTag.isSelfClosing()) {
            Element element = this.insertEmpty(startTag);
            this.stack.add(element);
            this.tokeniser.transition(TokeniserState.Data);
            this.tokeniser.emit(this.emptyEnd.reset().name(element.tagName()));
            return element;
        }
        Element element = new Element(this.tagFor(startTag.name(), this.settings), null, this.settings.normalizeAttributes(startTag.attributes));
        this.insert(element, startTag);
        return element;
    }

    Element insertStartTag(String string) {
        Element element = new Element(this.tagFor(string, this.settings), null);
        this.insert(element);
        return element;
    }

    void insert(Element element) {
        this.insertNode(element, null);
        this.stack.add(element);
    }

    private void insert(Element element, @Nullable Token token) {
        this.insertNode(element, token);
        this.stack.add(element);
    }

    Element insertEmpty(Token.StartTag startTag) {
        Tag tag = this.tagFor(startTag.name(), this.settings);
        Element element = new Element(tag, null, this.settings.normalizeAttributes(startTag.attributes));
        this.insertNode(element, startTag);
        if (startTag.isSelfClosing()) {
            if (tag.isKnownTag()) {
                if (!tag.isEmpty()) {
                    this.tokeniser.error("Tag [%s] cannot be self closing; not a void tag", tag.normalName());
                }
            } else {
                tag.setSelfClosing();
            }
        }
        return element;
    }

    FormElement insertForm(Token.StartTag startTag, boolean bl, boolean bl2) {
        Tag tag = this.tagFor(startTag.name(), this.settings);
        FormElement formElement = new FormElement(tag, null, this.settings.normalizeAttributes(startTag.attributes));
        if (bl2) {
            if (!this.onStack("template")) {
                this.setFormElement(formElement);
            }
        } else {
            this.setFormElement(formElement);
        }
        this.insertNode(formElement, startTag);
        if (bl) {
            this.stack.add(formElement);
        }
        return formElement;
    }

    void insert(Token.Comment comment) {
        Comment comment2 = new Comment(comment.getData());
        this.insertNode(comment2, comment);
    }

    void insert(Token.Character character) {
        Element element = this.currentElement();
        String string = element.normalName();
        String string2 = character.getData();
        LeafNode leafNode = character.isCData() ? new CDataNode(string2) : (this.isContentForTagData(string) ? new DataNode(string2) : new TextNode(string2));
        element.appendChild(leafNode);
        this.onNodeInserted(leafNode, character);
    }

    private void insertNode(Node node, @Nullable Token token) {
        if (this.stack.isEmpty()) {
            this.doc.appendChild(node);
        } else if (this.isFosterInserts() && StringUtil.inSorted(this.currentElement().normalName(), HtmlTreeBuilderState.Constants.InTableFoster)) {
            this.insertInFosterParent(node);
        } else {
            this.currentElement().appendChild(node);
        }
        if (node instanceof Element && ((Element)node).tag().isFormListed() && this.formElement != null) {
            this.formElement.addElement((Element)node);
        }
        this.onNodeInserted(node, token);
    }

    Element pop() {
        int n = this.stack.size();
        return (Element)this.stack.remove(n - 1);
    }

    void push(Element element) {
        this.stack.add(element);
    }

    ArrayList<Element> getStack() {
        return this.stack;
    }

    boolean onStack(Element element) {
        return HtmlTreeBuilder.onStack(this.stack, element);
    }

    boolean onStack(String string) {
        return this.getFromStack(string) != null;
    }

    private static boolean onStack(ArrayList<Element> arrayList, Element element) {
        int n = arrayList.size() - 1;
        int n2 = n >= 256 ? n - 256 : 0;
        for (int i = n; i >= n2; --i) {
            Element element2 = arrayList.get(i);
            if (element2 != element) continue;
            return true;
        }
        return false;
    }

    @Nullable
    Element getFromStack(String string) {
        int n = this.stack.size() - 1;
        int n2 = n >= 256 ? n - 256 : 0;
        for (int i = n; i >= n2; --i) {
            Element element = (Element)this.stack.get(i);
            if (!element.normalName().equals(string)) continue;
            return element;
        }
        return null;
    }

    boolean removeFromStack(Element element) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element2 = (Element)this.stack.get(i);
            if (element2 != element) continue;
            this.stack.remove(i);
            return true;
        }
        return false;
    }

    @Nullable
    Element popStackToClose(String string) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.stack.get(i);
            this.stack.remove(i);
            if (!element.normalName().equals(string)) continue;
            if (this.currentToken instanceof Token.EndTag) {
                this.onNodeClosed(element, this.currentToken);
            }
            return element;
        }
        return null;
    }

    void popStackToClose(String ... stringArray) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.stack.get(i);
            this.stack.remove(i);
            if (StringUtil.inSorted(element.normalName(), stringArray)) break;
        }
    }

    void popStackToBefore(String string) {
        Element element;
        for (int i = this.stack.size() - 1; i >= 0 && !(element = (Element)this.stack.get(i)).normalName().equals(string); --i) {
            this.stack.remove(i);
        }
    }

    void clearStackToTableContext() {
        this.clearStackToContext("table", "template");
    }

    void clearStackToTableBodyContext() {
        this.clearStackToContext("tbody", "tfoot", "thead", "template");
    }

    void clearStackToTableRowContext() {
        this.clearStackToContext("tr", "template");
    }

    private void clearStackToContext(String ... stringArray) {
        Element element;
        for (int i = this.stack.size() - 1; i >= 0 && !StringUtil.in((element = (Element)this.stack.get(i)).normalName(), stringArray) && !element.normalName().equals("html"); --i) {
            this.stack.remove(i);
        }
    }

    @Nullable
    Element aboveOnStack(Element element) {
        assert (this.onStack(element));
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element2 = (Element)this.stack.get(i);
            if (element2 != element) continue;
            return (Element)this.stack.get(i - 1);
        }
        return null;
    }

    void insertOnStackAfter(Element element, Element element2) {
        int n = this.stack.lastIndexOf(element);
        Validate.isTrue(n != -1);
        this.stack.add(n + 1, element2);
    }

    void replaceOnStack(Element element, Element element2) {
        this.replaceInQueue(this.stack, element, element2);
    }

    private void replaceInQueue(ArrayList<Element> arrayList, Element element, Element element2) {
        int n = arrayList.lastIndexOf(element);
        Validate.isTrue(n != -1);
        arrayList.set(n, element2);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean resetInsertionMode() {
        boolean bl = false;
        int n = this.stack.size() - 1;
        int n2 = n >= 256 ? n - 256 : 0;
        HtmlTreeBuilderState htmlTreeBuilderState = this.state;
        if (this.stack.size() == 0) {
            this.transition(HtmlTreeBuilderState.InBody);
        }
        block31: for (int i = n; i >= n2; --i) {
            String string;
            Element element = (Element)this.stack.get(i);
            if (i == n2) {
                bl = true;
                if (this.fragmentParsing) {
                    element = this.contextElement;
                }
            }
            switch (string = element != null ? element.normalName() : "") {
                case "select": {
                    this.transition(HtmlTreeBuilderState.InSelect);
                    break block31;
                }
                case "td": 
                case "th": {
                    if (bl) break;
                    this.transition(HtmlTreeBuilderState.InCell);
                    break block31;
                }
                case "tr": {
                    this.transition(HtmlTreeBuilderState.InRow);
                    break block31;
                }
                case "tbody": 
                case "thead": 
                case "tfoot": {
                    this.transition(HtmlTreeBuilderState.InTableBody);
                    break block31;
                }
                case "caption": {
                    this.transition(HtmlTreeBuilderState.InCaption);
                    break block31;
                }
                case "colgroup": {
                    this.transition(HtmlTreeBuilderState.InColumnGroup);
                    break block31;
                }
                case "table": {
                    this.transition(HtmlTreeBuilderState.InTable);
                    break block31;
                }
                case "template": {
                    HtmlTreeBuilderState htmlTreeBuilderState2 = this.currentTemplateMode();
                    Validate.notNull((Object)htmlTreeBuilderState2, "Bug: no template insertion mode on stack!");
                    this.transition(htmlTreeBuilderState2);
                    break block31;
                }
                case "head": {
                    if (bl) break;
                    this.transition(HtmlTreeBuilderState.InHead);
                    break block31;
                }
                case "body": {
                    this.transition(HtmlTreeBuilderState.InBody);
                    break block31;
                }
                case "frameset": {
                    this.transition(HtmlTreeBuilderState.InFrameset);
                    break block31;
                }
                case "html": {
                    this.transition(this.headElement == null ? HtmlTreeBuilderState.BeforeHead : HtmlTreeBuilderState.AfterHead);
                    break block31;
                }
            }
            if (!bl) continue;
            this.transition(HtmlTreeBuilderState.InBody);
            break;
        }
        if (this.state == htmlTreeBuilderState) return false;
        return true;
    }

    void resetBody() {
        if (!this.onStack("body")) {
            this.stack.add(this.doc.body());
        }
        this.transition(HtmlTreeBuilderState.InBody);
    }

    private boolean inSpecificScope(String string, String[] stringArray, String[] stringArray2) {
        this.specificScopeTarget[0] = string;
        return this.inSpecificScope(this.specificScopeTarget, stringArray, stringArray2);
    }

    private boolean inSpecificScope(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        int n = this.stack.size() - 1;
        int n2 = n > 100 ? n - 100 : 0;
        for (int i = n; i >= n2; --i) {
            String string = ((Element)this.stack.get(i)).normalName();
            if (StringUtil.inSorted(string, stringArray)) {
                return true;
            }
            if (StringUtil.inSorted(string, stringArray2)) {
                return false;
            }
            if (stringArray3 == null || !StringUtil.inSorted(string, stringArray3)) continue;
            return false;
        }
        return false;
    }

    boolean inScope(String[] stringArray) {
        return this.inSpecificScope(stringArray, TagsSearchInScope, null);
    }

    boolean inScope(String string) {
        return this.inScope(string, null);
    }

    boolean inScope(String string, String[] stringArray) {
        return this.inSpecificScope(string, TagsSearchInScope, stringArray);
    }

    boolean inListItemScope(String string) {
        return this.inScope(string, TagSearchList);
    }

    boolean inButtonScope(String string) {
        return this.inScope(string, TagSearchButton);
    }

    boolean inTableScope(String string) {
        return this.inSpecificScope(string, TagSearchTableScope, null);
    }

    boolean inSelectScope(String string) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.stack.get(i);
            String string2 = element.normalName();
            if (string2.equals(string)) {
                return true;
            }
            if (StringUtil.inSorted(string2, TagSearchSelectScope)) continue;
            return false;
        }
        Validate.fail("Should not be reachable");
        return false;
    }

    void setHeadElement(Element element) {
        this.headElement = element;
    }

    Element getHeadElement() {
        return this.headElement;
    }

    boolean isFosterInserts() {
        return this.fosterInserts;
    }

    void setFosterInserts(boolean bl) {
        this.fosterInserts = bl;
    }

    @Nullable
    FormElement getFormElement() {
        return this.formElement;
    }

    void setFormElement(FormElement formElement) {
        this.formElement = formElement;
    }

    void newPendingTableCharacters() {
        this.pendingTableCharacters = new ArrayList<String>();
    }

    List<String> getPendingTableCharacters() {
        return this.pendingTableCharacters;
    }

    void generateImpliedEndTags(String string) {
        while (StringUtil.inSorted(this.currentElement().normalName(), TagSearchEndTags) && (string == null || !this.currentElementIs(string))) {
            this.pop();
        }
    }

    void generateImpliedEndTags() {
        this.generateImpliedEndTags(false);
    }

    void generateImpliedEndTags(boolean bl) {
        String[] stringArray;
        String[] stringArray2 = stringArray = bl ? TagThoroughSearchEndTags : TagSearchEndTags;
        while (StringUtil.inSorted(this.currentElement().normalName(), stringArray)) {
            this.pop();
        }
    }

    void closeElement(String string) {
        this.generateImpliedEndTags(string);
        if (!string.equals(this.currentElement().normalName())) {
            this.error(this.state());
        }
        this.popStackToClose(string);
    }

    boolean isSpecial(Element element) {
        String string = element.normalName();
        return StringUtil.inSorted(string, TagSearchSpecial);
    }

    Element lastFormattingElement() {
        return this.formattingElements.size() > 0 ? this.formattingElements.get(this.formattingElements.size() - 1) : null;
    }

    int positionOfElement(Element element) {
        for (int i = 0; i < this.formattingElements.size(); ++i) {
            if (element != this.formattingElements.get(i)) continue;
            return i;
        }
        return -1;
    }

    Element removeLastFormattingElement() {
        int n = this.formattingElements.size();
        if (n > 0) {
            return this.formattingElements.remove(n - 1);
        }
        return null;
    }

    void pushActiveFormattingElements(Element element) {
        this.checkActiveFormattingElements(element);
        this.formattingElements.add(element);
    }

    void pushWithBookmark(Element element, int n) {
        this.checkActiveFormattingElements(element);
        try {
            this.formattingElements.add(n, element);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.formattingElements.add(element);
        }
    }

    void checkActiveFormattingElements(Element element) {
        Element element2;
        int n = 0;
        int n2 = this.formattingElements.size() - 1;
        int n3 = n2 - 12;
        if (n3 < 0) {
            n3 = 0;
        }
        for (int i = n2; i >= n3 && (element2 = this.formattingElements.get(i)) != null; --i) {
            if (this.isSameFormattingElement(element, element2)) {
                ++n;
            }
            if (n != 3) continue;
            this.formattingElements.remove(i);
            break;
        }
    }

    private boolean isSameFormattingElement(Element element, Element element2) {
        return element.normalName().equals(element2.normalName()) && element.attributes().equals(element2.attributes());
    }

    void reconstructFormattingElements() {
        if (this.stack.size() > 256) {
            return;
        }
        Element element = this.lastFormattingElement();
        if (element == null || this.onStack(element)) {
            return;
        }
        Element element2 = element;
        int n = this.formattingElements.size();
        int n2 = n - 12;
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n - 1;
        boolean bl = false;
        do {
            if (n3 != n2) continue;
            bl = true;
            break;
        } while ((element2 = this.formattingElements.get(--n3)) != null && !this.onStack(element2));
        do {
            if (!bl) {
                element2 = this.formattingElements.get(++n3);
            }
            Validate.notNull(element2);
            bl = false;
            Element element3 = new Element(this.tagFor(element2.normalName(), this.settings), null, element2.attributes().clone());
            this.insert(element3);
            this.formattingElements.set(n3, element3);
        } while (n3 != n - 1);
    }

    void clearFormattingElementsToLastMarker() {
        Element element;
        while (!this.formattingElements.isEmpty() && (element = this.removeLastFormattingElement()) != null) {
        }
    }

    void removeFromActiveFormattingElements(Element element) {
        for (int i = this.formattingElements.size() - 1; i >= 0; --i) {
            Element element2 = this.formattingElements.get(i);
            if (element2 != element) continue;
            this.formattingElements.remove(i);
            break;
        }
    }

    boolean isInActiveFormattingElements(Element element) {
        return HtmlTreeBuilder.onStack(this.formattingElements, element);
    }

    Element getActiveFormattingElement(String string) {
        Element element;
        for (int i = this.formattingElements.size() - 1; i >= 0 && (element = this.formattingElements.get(i)) != null; --i) {
            if (!element.normalName().equals(string)) continue;
            return element;
        }
        return null;
    }

    void replaceActiveFormattingElement(Element element, Element element2) {
        this.replaceInQueue(this.formattingElements, element, element2);
    }

    void insertMarkerToFormattingElements() {
        this.formattingElements.add(null);
    }

    void insertInFosterParent(Node node) {
        Element element;
        Element element2 = this.getFromStack("table");
        boolean bl = false;
        if (element2 != null) {
            if (element2.parent() != null) {
                element = element2.parent();
                bl = true;
            } else {
                element = this.aboveOnStack(element2);
            }
        } else {
            element = (Element)this.stack.get(0);
        }
        if (bl) {
            Validate.notNull(element2);
            element2.before(node);
        } else {
            element.appendChild(node);
        }
    }

    void pushTemplateMode(HtmlTreeBuilderState htmlTreeBuilderState) {
        this.tmplInsertMode.add(htmlTreeBuilderState);
    }

    @Nullable
    HtmlTreeBuilderState popTemplateMode() {
        if (this.tmplInsertMode.size() > 0) {
            return this.tmplInsertMode.remove(this.tmplInsertMode.size() - 1);
        }
        return null;
    }

    int templateModeSize() {
        return this.tmplInsertMode.size();
    }

    @Nullable
    HtmlTreeBuilderState currentTemplateMode() {
        return this.tmplInsertMode.size() > 0 ? this.tmplInsertMode.get(this.tmplInsertMode.size() - 1) : null;
    }

    public String toString() {
        return "TreeBuilder{currentToken=" + this.currentToken + ", state=" + (Object)((Object)this.state) + ", currentElement=" + this.currentElement() + '}';
    }

    @Override
    protected boolean isContentForTagData(String string) {
        return string.equals("script") || string.equals("style");
    }
}

