/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.particles;

import com.cryptomorin.xseries.particles.XParticle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;

public class ParticleDisplay
implements Cloneable {
    private static final boolean ISFLAT = XParticle.getParticle("FOOTSTEP") == null;
    private static final boolean SUPPORTS_DUST_TRANSITION = XParticle.getParticle("DUST_COLOR_TRANSITION") != null;
    private static final Axis[] DEFAULT_ROTATION_ORDER = new Axis[]{Axis.X, Axis.Y, Axis.Z};
    private static final Particle DEFAULT_PARTICLE = Particle.CLOUD;
    public int count = 1;
    public double extra;
    public boolean force;
    @Nonnull
    private Particle particle = DEFAULT_PARTICLE;
    @Nullable
    private Location location;
    @Nullable
    private Callable<Location> locationCaller;
    @Nullable
    private Vector rotation;
    @Nullable
    private Vector offset = new Vector();
    @Nonnull
    private Axis[] rotationOrder = DEFAULT_ROTATION_ORDER;
    @Nullable
    private Object data;
    @Nullable
    private Predicate<Location> onSpawn;

    @Nonnull
    public static ParticleDisplay colored(@Nullable Location location, int n, int n2, int n3, float f) {
        return ParticleDisplay.simple(location, Particle.REDSTONE).withColor(n, n2, n3, f);
    }

    @Nonnull
    public static ParticleDisplay colored(@Nullable Location location, @Nonnull Color color, float f) {
        return ParticleDisplay.colored(location, color.getRed(), color.getGreen(), color.getBlue(), f);
    }

    @Nonnull
    public static ParticleDisplay simple(@Nullable Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(particle, "Cannot build ParticleDisplay with null particle");
        ParticleDisplay particleDisplay = new ParticleDisplay();
        particleDisplay.particle = particle;
        particleDisplay.location = location;
        return particleDisplay;
    }

    @Nonnull
    public static ParticleDisplay of(@Nonnull Particle particle) {
        return ParticleDisplay.simple(null, particle);
    }

    @Nonnull
    public static ParticleDisplay display(@Nonnull Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(location, "Cannot display particle in null location");
        ParticleDisplay particleDisplay = ParticleDisplay.simple(location, particle);
        particleDisplay.spawn();
        return particleDisplay;
    }

    public static ParticleDisplay fromConfig(@Nonnull ConfigurationSection configurationSection) {
        return ParticleDisplay.edit(new ParticleDisplay(), configurationSection);
    }

    private static int toInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static double toDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    private static List<String> split(@Nonnull String string, char c) {
        ArrayList<String> arrayList = new ArrayList<String>(5);
        boolean bl = false;
        boolean bl2 = false;
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == c) {
                if (bl) {
                    arrayList.add(string.substring(n2, i));
                    bl = false;
                    bl2 = true;
                }
                n2 = i + 1;
                continue;
            }
            bl2 = false;
            bl = true;
        }
        if (bl || bl2) {
            arrayList.add(string.substring(n2, n));
        }
        return arrayList;
    }

    @Nonnull
    public static ParticleDisplay edit(@Nonnull ParticleDisplay particleDisplay, @Nonnull ConfigurationSection configurationSection) {
        Object object;
        float f;
        String string;
        List<String> list;
        List<String> list2;
        String string2;
        Particle particle;
        Objects.requireNonNull(particleDisplay, "Cannot edit a null particle display");
        Objects.requireNonNull(configurationSection, "Cannot parse ParticleDisplay from a null config section");
        String string3 = configurationSection.getString("particle");
        Particle particle2 = particle = string3 == null ? null : XParticle.getParticle(string3);
        if (particle != null) {
            particleDisplay.particle = particle;
        }
        if (configurationSection.isSet("count")) {
            particleDisplay.withCount(configurationSection.getInt("count"));
        }
        if (configurationSection.isSet("extra")) {
            particleDisplay.withExtra(configurationSection.getDouble("extra"));
        }
        if (configurationSection.isSet("force")) {
            particleDisplay.forceSpawn(configurationSection.getBoolean("force"));
        }
        if ((string2 = configurationSection.getString("offset")) != null) {
            double d;
            list2 = ParticleDisplay.split(string2.replace(" ", ""), ',');
            if (list2.size() >= 3) {
                d = ParticleDisplay.toDouble((String)list2.get(0));
                double d2 = ParticleDisplay.toDouble((String)list2.get(1));
                double d3 = ParticleDisplay.toDouble((String)list2.get(2));
                particleDisplay.offset(d, d2, d3);
            } else {
                d = ParticleDisplay.toDouble((String)list2.get(0));
                particleDisplay.offset(d);
            }
        }
        if ((list2 = configurationSection.getString("rotation")) != null && (list = ParticleDisplay.split(((String)((Object)list2)).replace(" ", ""), ',')).size() >= 3) {
            double d = Math.toRadians(ParticleDisplay.toDouble(list.get(0)));
            double d4 = Math.toRadians(ParticleDisplay.toDouble(list.get(1)));
            double d5 = Math.toRadians(ParticleDisplay.toDouble(list.get(2)));
            particleDisplay.rotation = new Vector(d, d4, d5);
        }
        if ((string = configurationSection.getString("rotation-order")) != null) {
            string = string.replace(" ", "").toUpperCase(Locale.ENGLISH);
            particleDisplay.rotationOrder(Axis.valueOf(String.valueOf(string.charAt(0))), Axis.valueOf(String.valueOf(string.charAt(1))), Axis.valueOf(String.valueOf(string.charAt(2))));
        }
        String string4 = configurationSection.getString("color");
        String string5 = configurationSection.getString("blockdata");
        String string6 = configurationSection.getString("itemstack");
        String string7 = configurationSection.getString("materialdata");
        if (configurationSection.isSet("size")) {
            f = (float)configurationSection.getDouble("size");
            if (particleDisplay.data instanceof float[] && ((Material)(object = (Object)((float[])particleDisplay.data))).length > 3) {
                object[3] = f;
            }
        } else {
            f = 1.0f;
        }
        if (string4 != null) {
            object = ParticleDisplay.split(string4.replace(" ", ""), ',');
            if (object.size() <= 3 || object.size() == 6) {
                Color color = Color.white;
                Color color2 = null;
                if (object.size() <= 2) {
                    try {
                        color = Color.decode((String)object.get(0));
                        if (object.size() == 2) {
                            color2 = Color.decode((String)object.get(1));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    color = new Color(ParticleDisplay.toInt((String)object.get(0)), ParticleDisplay.toInt((String)object.get(1)), ParticleDisplay.toInt((String)object.get(2)));
                    if (object.size() == 6) {
                        color2 = new Color(ParticleDisplay.toInt((String)object.get(3)), ParticleDisplay.toInt((String)object.get(4)), ParticleDisplay.toInt((String)object.get(5)));
                    }
                }
                particleDisplay.data = color2 != null ? (Object)new float[]{color.getRed(), color.getGreen(), color.getBlue(), f, color2.getRed(), color2.getGreen(), color2.getBlue()} : (Object)new float[]{color.getRed(), color.getGreen(), color.getBlue(), f};
            }
        } else if (string5 != null) {
            object = Material.getMaterial((String)string5);
            if (object != null && object.isBlock()) {
                particleDisplay.data = object.createBlockData();
            }
        } else if (string6 != null) {
            object = Material.getMaterial((String)string6);
            if (object != null && object.isItem()) {
                particleDisplay.data = new ItemStack((Material)object, 1);
            }
        } else if (string7 != null && (object = Material.getMaterial((String)string7)) != null && object.isBlock()) {
            particleDisplay.data = object.getData();
        }
        return particleDisplay;
    }

    public static Vector rotateAround(@Nonnull Vector vector, @Nonnull Axis axis, @Nonnull Vector vector2) {
        Objects.requireNonNull(axis, "Cannot rotate around null axis");
        Objects.requireNonNull(vector2, "Rotation vector cannot be null");
        switch (axis) {
            case X: {
                return ParticleDisplay.rotateAround(vector, axis, vector2.getX());
            }
            case Y: {
                return ParticleDisplay.rotateAround(vector, axis, vector2.getY());
            }
            case Z: {
                return ParticleDisplay.rotateAround(vector, axis, vector2.getZ());
            }
        }
        throw new AssertionError((Object)("Unknown rotation axis: " + (Object)((Object)axis)));
    }

    public static Vector rotateAround(@Nonnull Vector vector, double d, double d2, double d3) {
        ParticleDisplay.rotateAround(vector, Axis.X, d);
        ParticleDisplay.rotateAround(vector, Axis.Y, d2);
        ParticleDisplay.rotateAround(vector, Axis.Z, d3);
        return vector;
    }

    public static Vector rotateAround(@Nonnull Vector vector, @Nonnull Axis axis, double d) {
        Objects.requireNonNull(vector, "Cannot rotate a null location");
        Objects.requireNonNull(axis, "Cannot rotate around null axis");
        if (d == 0.0) {
            return vector;
        }
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        switch (axis) {
            case X: {
                double d4 = vector.getY() * d2 - vector.getZ() * d3;
                double d5 = vector.getY() * d3 + vector.getZ() * d2;
                return vector.setY(d4).setZ(d5);
            }
            case Y: {
                double d6 = vector.getX() * d2 + vector.getZ() * d3;
                double d7 = vector.getX() * -d3 + vector.getZ() * d2;
                return vector.setX(d6).setZ(d7);
            }
            case Z: {
                double d8 = vector.getX() * d2 - vector.getY() * d3;
                double d9 = vector.getX() * d3 + vector.getY() * d2;
                return vector.setX(d8).setY(d9);
            }
        }
        throw new AssertionError((Object)("Unknown rotation axis: " + (Object)((Object)axis)));
    }

    public ParticleDisplay onSpawn(@Nullable Predicate<Location> predicate) {
        this.onSpawn = predicate;
        return this;
    }

    public void withParticle(@Nonnull Particle particle) {
        this.particle = Objects.requireNonNull(particle, "Particle cannot be null");
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public String toString() {
        Location location = this.getLocation();
        return "ParticleDisplay:[Particle=" + this.particle + ", Count=" + this.count + ", Offset:{" + this.offset.getX() + ", " + this.offset.getY() + ", " + this.offset.getZ() + "}, " + (location != null ? "Location:{" + location.getWorld().getName() + location.getX() + ", " + location.getY() + ", " + location.getZ() + "} " + '(' + (this.locationCaller == null ? "Static" : "Dynamic") + "), " : "") + (this.rotation != null ? "Rotation:{" + Math.toDegrees(this.rotation.getX()) + ", " + Math.toRadians(this.rotation.getY()) + ", " + Math.toDegrees(this.rotation.getZ()) + "}, " : "") + (this.rotationOrder != DEFAULT_ROTATION_ORDER ? "RotationOrder:" + Arrays.toString((Object[])this.rotationOrder) + ", " : "") + "Extra=" + this.extra + ", Force=" + this.force + ", Data=" + (this.data == null ? "null" : (this.data instanceof float[] ? Arrays.toString((float[])this.data) : this.data));
    }

    @Nonnull
    public ParticleDisplay withCount(int n) {
        this.count = n;
        return this;
    }

    @Nonnull
    public ParticleDisplay withExtra(double d) {
        this.extra = d;
        return this;
    }

    @Nonnull
    public ParticleDisplay forceSpawn(boolean bl) {
        this.force = bl;
        return this;
    }

    @Nonnull
    public ParticleDisplay withColor(@Nonnull Color color, float f) {
        return this.withColor(color.getRed(), color.getGreen(), color.getBlue(), f);
    }

    @Nonnull
    public ParticleDisplay withColor(float f, float f2, float f3, float f4) {
        this.data = new float[]{f, f2, f3, f4};
        return this;
    }

    @Nonnull
    public ParticleDisplay withTransitionColor(@Nonnull Color color, float f, @Nonnull Color color2) {
        return this.withTransitionColor(color.getRed(), color.getGreen(), color.getBlue(), f, color2.getRed(), color2.getGreen(), color2.getBlue());
    }

    @Nonnull
    public ParticleDisplay withTransitionColor(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.data = new float[]{f, f2, f3, f4, f5, f6, f7};
        return this;
    }

    @Nonnull
    public ParticleDisplay withBlock(@Nonnull BlockData blockData) {
        this.data = blockData;
        return this;
    }

    @Nonnull
    public ParticleDisplay withBlock(@Nonnull MaterialData materialData) {
        this.data = materialData;
        return this;
    }

    @Nonnull
    public ParticleDisplay withItem(@Nonnull ItemStack itemStack) {
        this.data = itemStack;
        return this;
    }

    @Nullable
    public Vector getOffset() {
        return this.offset;
    }

    @Nonnull
    public ParticleDisplay withEntity(@Nonnull Entity entity) {
        return this.withLocationCaller(() -> ((Entity)entity).getLocation());
    }

    @Nonnull
    public ParticleDisplay withLocationCaller(@Nullable Callable<Location> callable) {
        this.locationCaller = callable;
        return this;
    }

    public ParticleDisplay rotationOrder(@Nonnull Axis axis, @Nonnull Axis axis2, @Nonnull Axis axis3) {
        Objects.requireNonNull(axis, "First rotation order axis is null");
        Objects.requireNonNull(axis2, "Second rotation order axis is null");
        Objects.requireNonNull(axis3, "Third rotation order axis is null");
        this.rotationOrder = new Axis[]{axis, axis2, axis3};
        return this;
    }

    @Nullable
    public Location getLocation() {
        try {
            return this.locationCaller == null ? this.location : this.locationCaller.call();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.location;
        }
    }

    public ParticleDisplay withLocation(@Nullable Location location) {
        this.location = location;
        return this;
    }

    @Nonnull
    public ParticleDisplay face(@Nonnull Entity entity) {
        return this.face(Objects.requireNonNull(entity, "Cannot face null entity").getLocation());
    }

    @Nonnull
    public ParticleDisplay face(@Nonnull Location location) {
        Objects.requireNonNull(location, "Cannot face null location");
        this.rotation = new Vector(Math.toRadians(location.getPitch() + 90.0f), Math.toRadians(-location.getYaw()), 0.0);
        return this;
    }

    @Nullable
    public Location cloneLocation(double d, double d2, double d3) {
        return this.location == null ? null : ParticleDisplay.cloneLocation(this.location).add(d, d2, d3);
    }

    @Nonnull
    private static Location cloneLocation(@Nonnull Location location) {
        return new Location(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Nonnull
    public ParticleDisplay cloneWithLocation(double d, double d2, double d3) {
        ParticleDisplay particleDisplay = this.clone();
        if (this.location == null) {
            return particleDisplay;
        }
        particleDisplay.location.add(d, d2, d3);
        return particleDisplay;
    }

    @Nonnull
    public ParticleDisplay clone() {
        ParticleDisplay particleDisplay = ParticleDisplay.of(this.particle).withLocationCaller(this.locationCaller).withCount(this.count).offset(this.offset.clone()).forceSpawn(this.force).onSpawn(this.onSpawn);
        if (this.location != null) {
            particleDisplay.location = ParticleDisplay.cloneLocation(this.location);
        }
        if (this.rotation != null) {
            particleDisplay.rotation = this.rotation.clone();
        }
        particleDisplay.rotationOrder = this.rotationOrder;
        particleDisplay.data = this.data;
        return particleDisplay;
    }

    @Nonnull
    public ParticleDisplay rotate(@Nonnull Vector vector) {
        Objects.requireNonNull(vector, "Cannot rotate ParticleDisplay with null vector");
        if (this.rotation == null) {
            this.rotation = vector;
        } else {
            this.rotation.add(vector);
        }
        return this;
    }

    @Nonnull
    public ParticleDisplay rotate(double d, double d2, double d3) {
        return this.rotate(new Vector(d, d2, d3));
    }

    @Nonnull
    public Location rotate(@Nonnull Location location, double d, double d2, double d3) {
        if (location == null) {
            throw new IllegalStateException("Attempting to spawn particle when no location is set");
        }
        if (this.rotation == null) {
            return ParticleDisplay.cloneLocation(location).add(d, d2, d3);
        }
        Vector vector = new Vector(d, d2, d3);
        ParticleDisplay.rotateAround(vector, this.rotationOrder[0], this.rotation);
        ParticleDisplay.rotateAround(vector, this.rotationOrder[1], this.rotation);
        ParticleDisplay.rotateAround(vector, this.rotationOrder[2], this.rotation);
        return ParticleDisplay.cloneLocation(location).add(vector);
    }

    @Nonnull
    public ParticleDisplay offset(double d, double d2, double d3) {
        return this.offset(new Vector(d, d2, d3));
    }

    @Nonnull
    public ParticleDisplay offset(@Nonnull Vector vector) {
        this.offset = Objects.requireNonNull(vector, "Particle offset cannot be null");
        return this;
    }

    @Nonnull
    public ParticleDisplay offset(double d) {
        return this.offset(d, d, d);
    }

    @Nullable
    public Vector getRotation() {
        return this.rotation;
    }

    public void setRotation(@Nullable Vector vector) {
        this.rotation = vector;
    }

    @Nonnull
    public ParticleDisplay directional() {
        this.count = 0;
        return this;
    }

    public boolean isDirectional() {
        return this.count == 0;
    }

    public void spawn() {
        this.spawn(this.getLocation());
    }

    @Nonnull
    public Location spawn(@Nonnull Vector vector) {
        Objects.requireNonNull(vector, "Cannot add xyz of null vector to ParticleDisplay");
        return this.spawn(vector.getX(), vector.getY(), vector.getZ());
    }

    @Nonnull
    public Location spawn(double d, double d2, double d3) {
        return this.spawn(this.rotate(this.getLocation(), d, d2, d3));
    }

    @Nonnull
    public Location spawn(@Nonnull Location location) {
        return this.spawn(location, null);
    }

    @Nonnull
    public Location spawn(Location location, Player ... playerArray) {
        if (location == null) {
            throw new IllegalStateException("Attempting to spawn particle when no location is set");
        }
        if (this.onSpawn != null && !this.onSpawn.test(location)) {
            return location;
        }
        World world = location.getWorld();
        double d = this.offset.getX();
        double d2 = this.offset.getY();
        double d3 = this.offset.getZ();
        if (this.data != null && this.data instanceof float[]) {
            float[] fArray = (float[])this.data;
            if (ISFLAT && this.particle.getDataType() == Particle.DustOptions.class) {
                Particle.DustOptions dustOptions = new Particle.DustOptions(org.bukkit.Color.fromRGB((int)((int)fArray[0]), (int)((int)fArray[1]), (int)((int)fArray[2])), fArray[3]);
                if (playerArray == null) {
                    world.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, (Object)dustOptions, this.force);
                } else {
                    for (Player player : playerArray) {
                        player.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, (Object)dustOptions);
                    }
                }
            } else if (SUPPORTS_DUST_TRANSITION && this.particle.getDataType() == Particle.DustTransition.class) {
                Particle.DustTransition dustTransition = new Particle.DustTransition(org.bukkit.Color.fromRGB((int)((int)fArray[0]), (int)((int)fArray[1]), (int)((int)fArray[2])), org.bukkit.Color.fromRGB((int)((int)fArray[4]), (int)((int)fArray[5]), (int)((int)fArray[6])), fArray[3]);
                if (playerArray == null) {
                    world.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, (Object)dustTransition, this.force);
                } else {
                    for (Player player : playerArray) {
                        player.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, (Object)dustTransition);
                    }
                }
            } else if (this.isDirectional()) {
                float[] fArray2 = new float[]{fArray[0] / 255.0f, fArray[1] / 255.0f, fArray[2] / 255.0f};
                if (playerArray == null) {
                    if (ISFLAT) {
                        world.spawnParticle(this.particle, location, this.count, (double)fArray2[0], (double)fArray2[1], (double)fArray2[2], (double)fArray[3], null, this.force);
                    } else {
                        world.spawnParticle(this.particle, location, this.count, (double)fArray2[0], (double)fArray2[1], (double)fArray2[2], (double)fArray[3], null);
                    }
                } else {
                    for (Player player : playerArray) {
                        player.spawnParticle(this.particle, location, this.count, (double)fArray2[0], (double)fArray2[1], (double)fArray2[2], (double)fArray[3]);
                    }
                }
            } else if (playerArray == null) {
                if (ISFLAT) {
                    world.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, null, this.force);
                } else {
                    world.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, null);
                }
            } else {
                for (Player player : playerArray) {
                    player.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra);
                }
            }
        } else {
            Object object;
            Object object2 = object = this.particle.getDataType().isInstance(this.data) ? this.data : null;
            if (playerArray == null) {
                if (ISFLAT) {
                    world.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, object, this.force);
                } else {
                    world.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, object);
                }
            } else {
                for (Player player : playerArray) {
                    player.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, object);
                }
            }
        }
        return location;
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

