/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation11;

import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.utils.LocationUtils;
import me.davidml16.acubelets.utils.ParticlesAPI.Particles;
import me.davidml16.acubelets.utils.ParticlesAPI.UtilParticles;
import me.davidml16.acubelets.utils.Sounds;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Animation11_Planet
extends BukkitRunnable {
    private final ArmorStand armorStand;
    private final List<Location> locations;
    private int step;
    private double rotSpeed;

    public Animation11_Planet(Main main, ItemStack itemStack, Location location, float f, int n, boolean bl, double d, int n2) {
        this.locations = LocationUtils.getCircle(location, f, n);
        this.rotSpeed = d;
        this.step = n2;
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(this.locations.get(n2), ArmorStand.class);
        NBTEditor.set(armorStand, (byte)1, "Silent");
        armorStand.setSilent(true);
        armorStand.setVisible(false);
        armorStand.setGravity(false);
        armorStand.setHelmet(itemStack);
        armorStand.setSmall(bl);
        armorStand.setMarker(false);
        armorStand.setRemoveWhenFarAway(false);
        armorStand.setCustomNameVisible(false);
        armorStand.setMetadata("ACUBELETS", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)Boolean.TRUE));
        armorStand.teleport(this.locations.get(n2));
        main.getAnimationHandler().getEntities().add((Entity)armorStand);
        Sounds.playSound(armorStand.getLocation(), Sounds.MySound.ORB_PICKUP, 0.5f, 3.0f);
        this.armorStand = armorStand;
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int n) {
        this.step = n;
    }

    public void run() {
        this.armorStand.teleport(this.locations.get(this.step));
        this.armorStand.setHeadPose(this.armorStand.getHeadPose().add(0.0, this.rotSpeed, 0.0));
        if (this.step % 3 == 0) {
            UtilParticles.display(Particles.FIREWORKS_SPARK, this.armorStand.getLocation().add(0.0, 1.0, 0.0), 1);
        }
        ++this.step;
        if (this.step >= this.locations.size()) {
            this.step = 0;
        }
    }
}

