/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation12;

import com.cryptomorin.xseries.XMaterial;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.ASSpawner;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.animations.animation.animation12.Animation12_Blocks;
import me.davidml16.acubelets.animations.animation.animation12.Animation12_Charge;
import me.davidml16.acubelets.animations.animation.animation12.Animation12_Orbit;
import me.davidml16.acubelets.utils.ParticlesAPI.Particles;
import me.davidml16.acubelets.utils.ParticlesAPI.UtilParticles;
import me.davidml16.acubelets.utils.Sounds;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Animation12_Task
extends Animation {
    private ArmorStand glassStand;
    private ArmorStand liquidStand;
    private Location glassLocation;
    private Location liquidLocation;
    private List<ItemStack> wools = new ArrayList<ItemStack>();
    private int actualWool = 0;
    private Set<Animation12_Orbit> orbits = new HashSet<Animation12_Orbit>();
    private LivingEntity witch;
    private Location witchLocation;
    private double rotSpeed = 0.001;

    public Animation12_Task(Main main, AnimationSettings animationSettings) {
        super(main, animationSettings);
    }

    @Override
    public void onTick(int n) {
        if (n == 45) {
            this.glassStand = ASSpawner.spawn(this.getMain(), this.getCubeletBox().getLocation().clone().add(0.5, -1.1, 0.5), XMaterial.GLASS.parseItem(), false, false, false);
            this.glassLocation = this.glassStand.getLocation();
            this.getMain().getAnimationHandler().getEntities().add((Entity)this.glassStand);
            this.liquidStand = ASSpawner.spawn(this.getMain(), this.getCubeletBox().getLocation().clone().add(0.5, -0.3, 0.5), XMaterial.RED_WOOL.parseItem(), false, false, true);
            this.liquidLocation = this.liquidStand.getLocation();
            this.getMain().getAnimationHandler().getEntities().add((Entity)this.liquidStand);
            this.witch = (LivingEntity)this.getCubeletBox().getLocation().getWorld().spawnEntity(this.getLocationRotation(0.0), EntityType.WITCH);
            this.witch.setCollidable(false);
            this.witch.setRemoveWhenFarAway(false);
            this.witch.setMetadata("ACUBELETS", (MetadataValue)new FixedMetadataValue((Plugin)this.getMain(), (Object)Boolean.TRUE));
            NBTEditor.set(this.witch, (byte)1, "Silent");
            NBTEditor.set(this.witch, (byte)1, "Invulnerable");
            NBTEditor.set(this.witch, (byte)1, "NoAI");
            this.witchLocation = this.witch.getLocation();
            this.witchLocation.setYaw(this.getCubeletBox().getRotation().value);
            this.witchLocation.setPitch(0.0f);
            this.witch.teleport(this.witchLocation);
            Animation12_Orbit animation12_Orbit = new Animation12_Orbit(this.getMain(), this.glassLocation.clone().add(0.0, 3.5, 0.0), 3.0f, 90, true, 0);
            animation12_Orbit.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.orbits.add(animation12_Orbit);
            Animation12_Orbit animation12_Orbit2 = new Animation12_Orbit(this.getMain(), this.glassLocation.clone().add(0.0, 3.5, 0.0), 3.0f, 90, true, 45);
            animation12_Orbit2.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.orbits.add(animation12_Orbit2);
        }
        if (n > 45 && n < 155) {
            if (this.glassStand != null) {
                if (n < 94) {
                    this.glassLocation.add(0.0, 0.021, 0.0);
                }
                if (n > 85) {
                    this.glassStand.setHeadPose(this.glassStand.getHeadPose().add(0.0, this.rotSpeed, 0.0));
                }
                this.glassStand.teleport(this.glassLocation);
            }
            if (this.liquidStand != null) {
                if (n < 94) {
                    this.liquidLocation.add(0.0, 0.021, 0.0);
                }
                if (n > 85) {
                    this.liquidStand.setHeadPose(this.liquidStand.getHeadPose().add(0.0, this.rotSpeed, 0.0));
                }
                this.liquidStand.teleport(this.liquidLocation);
                if (n % 2 == 0) {
                    if (n < 94) {
                        Sounds.playSound(this.liquidStand.getLocation(), Sounds.MySound.ORB_PICKUP, 0.5f, (float)ThreadLocalRandom.current().nextDouble(1.0, 3.0));
                    }
                    this.liquidStand.setHelmet(this.wools.get(this.actualWool));
                    ++this.actualWool;
                    if (this.actualWool >= this.wools.size()) {
                        this.actualWool = 0;
                    }
                }
            }
            this.rotSpeed += 0.003;
        }
        if (n == 100) {
            this.chargeParticles();
        }
        if (n == 153) {
            this.doPreRewardReveal();
        }
        if (n == 175) {
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.LEVEL_UP, 0.5f, 1.0f);
        }
        if (n > 45 && n < 145) {
            UtilParticles.drawParticleLine(this.getCorner1().clone().add(0.0, -0.5, 0.0), this.getCorner2().clone().add(0.0, -0.5, 0.0), Particles.SPELL_WITCH, 5, 0, 0, 0);
            UtilParticles.drawParticleLine(this.getCorner2().clone().add(0.0, -0.5, 0.0), this.getCorner3().clone().add(0.0, -0.5, 0.0), Particles.SPELL_WITCH, 5, 0, 0, 0);
            UtilParticles.drawParticleLine(this.getCorner3().clone().add(0.0, -0.5, 0.0), this.getCorner4().clone().add(0.0, -0.5, 0.0), Particles.SPELL_WITCH, 5, 0, 0, 0);
            UtilParticles.drawParticleLine(this.getCorner1().clone().add(0.0, -0.5, 0.0), this.getCorner4().clone().add(0.0, -0.5, 0.0), Particles.SPELL_WITCH, 5, 0, 0, 0);
        }
    }

    @Override
    public void onStart() {
        this.setAnimationBlocks(new Animation12_Blocks(this.getCubeletBox().getLocation()));
        this.startAnimationBlocks(0L);
        this.setColors(Arrays.asList(Color.PURPLE, Color.FUCHSIA));
        this.wools.add(XMaterial.WHITE_WOOL.parseItem());
        this.wools.add(XMaterial.RED_WOOL.parseItem());
        this.wools.add(XMaterial.GREEN_WOOL.parseItem());
        this.wools.add(XMaterial.BLACK_WOOL.parseItem());
        this.wools.add(XMaterial.BLUE_WOOL.parseItem());
        this.wools.add(XMaterial.BROWN_WOOL.parseItem());
        this.wools.add(XMaterial.GRAY_WOOL.parseItem());
        this.wools.add(XMaterial.LIME_WOOL.parseItem());
        this.wools.add(XMaterial.MAGENTA_WOOL.parseItem());
        this.wools.add(XMaterial.ORANGE_WOOL.parseItem());
        this.wools.add(XMaterial.PINK_WOOL.parseItem());
        this.wools.add(XMaterial.PURPLE_WOOL.parseItem());
        this.wools.add(XMaterial.YELLOW_WOOL.parseItem());
        this.addRunnable("charge", new Animation12_Charge(this.getCubeletBox().getLocation()));
        this.startRunnable("charge", 105L, 3L);
    }

    @Override
    public void onStop() {
        this.stopAnimationBlocks();
        if (this.getMain().getAnimationHandler().getEntities().contains(this.glassStand)) {
            if (this.glassStand != null) {
                this.glassStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(this.glassStand);
        }
        if (this.getMain().getAnimationHandler().getEntities().contains(this.liquidStand)) {
            if (this.liquidStand != null) {
                this.liquidStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(this.liquidStand);
        }
        try {
            for (Animation12_Orbit animation12_Orbit : this.orbits) {
                animation12_Orbit.cancel();
                if (!this.getMain().getAnimationHandler().getEntities().contains(animation12_Orbit.getArmorStand())) continue;
                ArmorStand armorStand = animation12_Orbit.getArmorStand();
                if (armorStand != null) {
                    armorStand.remove();
                }
                this.getMain().getAnimationHandler().getEntities().remove(armorStand);
            }
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void onPreRewardReveal() {
        Sounds.playSound(this.liquidStand.getLocation(), Sounds.MySound.EXPLODE, 0.5f, 1.0f);
        this.getMain().getFireworkUtil().spawn(this.getCubeletBox().getLocation().clone().add(0.5, 1.5, 0.5), FireworkEffect.Type.BALL_LARGE, this.getColors().get(0), this.getColors().get(1));
    }

    @Override
    public void onRewardReveal() {
        this.witch.remove();
        this.glassStand.remove();
        this.glassStand = null;
        this.liquidStand.remove();
        this.liquidStand = null;
    }

    private void chargeParticles() {
        Random random = new Random();
        Location location = this.liquidStand.getLocation().clone().add(0.0, 1.0, 0.0);
        for (int i = 0; i < 500; ++i) {
            Location location2 = location.clone();
            location2.add((random.nextDouble() - 0.5) / 2.0, (new Random().nextDouble() - 0.5) / 2.0, (random.nextDouble() - 0.5) / 2.0);
            Vector vector = location2.toVector().subtract(location.toVector()).normalize();
            Vector vector2 = vector.multiply(1.5 + new Random().nextDouble() * 5.0);
            for (int j = 0; j < 3; ++j) {
                UtilParticles.display(Particles.PORTAL, vector2, location, 5.0f);
            }
        }
    }
}

