/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation21;

import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.awt.Color;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.utils.LocationUtils;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Animation21_RotatingParticle
extends BukkitRunnable {
    private final ArmorStand armorStand;
    private List<Location> locations;
    private int step;
    private double yDif;
    private boolean isWhite;
    private Location center;
    private double radius;
    private int points;

    public Animation21_RotatingParticle(Main main, Location location, double d, int n, boolean bl, int n2, boolean bl2) {
        this.locations = LocationUtils.getCircle(location, d, n);
        this.step = n2;
        this.yDif = 0.0;
        this.isWhite = bl2;
        this.center = location;
        this.radius = d;
        this.points = n;
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(this.locations.get(n2), ArmorStand.class);
        NBTEditor.set(armorStand, (byte)1, "Silent");
        if (bl2) {
            armorStand.setHelmet(XMaterial.WHITE_CONCRETE.parseItem());
        } else {
            armorStand.setHelmet(XMaterial.BLACK_CONCRETE.parseItem());
        }
        armorStand.setSilent(true);
        armorStand.setVisible(false);
        armorStand.setGravity(false);
        armorStand.setSmall(bl);
        armorStand.setMarker(false);
        armorStand.setRemoveWhenFarAway(false);
        armorStand.setCustomNameVisible(false);
        armorStand.setMetadata("ACUBELETS", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)Boolean.TRUE));
        armorStand.teleport(this.locations.get(n2));
        main.getAnimationHandler().getEntities().add((Entity)armorStand);
        this.armorStand = armorStand;
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int n) {
        this.step = n;
    }

    public void run() {
        Location location = this.locations.get(this.step);
        Location location2 = location.clone().add(0.0, this.yDif, 0.0);
        if (this.step + 1 >= this.locations.size()) {
            location2.setDirection(this.locations.get(0).clone().add(0.0, this.yDif, 0.0).toVector().subtract(location2.toVector()));
        } else {
            location2.setDirection(this.locations.get(this.step + 1).clone().add(0.0, this.yDif, 0.0).toVector().subtract(location2.toVector()));
        }
        this.armorStand.teleport(location2);
        if (this.isWhite) {
            ParticleDisplay.colored(this.armorStand.getLocation().add(this.armorStand.getLocation().getDirection().normalize().multiply(-1).multiply(1)).add(0.0, 1.0, 0.0), Color.WHITE, 3.0f).spawn();
        } else {
            ParticleDisplay.colored(this.armorStand.getLocation().add(this.armorStand.getLocation().getDirection().normalize().multiply(-1).multiply(1)).add(0.0, 1.0, 0.0), Color.BLACK, 3.0f).spawn();
        }
        ++this.step;
        if (this.step >= this.locations.size()) {
            this.step = 0;
        }
        if (this.yDif < 4.0) {
            this.yDif += 0.095;
        }
        if (this.radius < 2.25) {
            this.radius += 0.05;
            this.locations = LocationUtils.getCircle(this.center, this.radius, this.points);
        }
    }
}

