/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation4;

import com.cryptomorin.xseries.XMaterial;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.Arrays;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.ASSpawner;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.animations.animation.animation4.Animation4_3x3Particles;
import me.davidml16.acubelets.animations.animation.animation4.Animation4_Arch;
import me.davidml16.acubelets.animations.animation.animation4.Animation4_ArchSounds;
import me.davidml16.acubelets.animations.animation.animation4.Animation4_Blocks;
import me.davidml16.acubelets.animations.animation.animation4.Animation4_EntityPackets;
import me.davidml16.acubelets.animations.animation.animation4.Animation4_Music;
import me.davidml16.acubelets.utils.Sounds;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class Animation4_Task
extends Animation {
    private ArmorStand armorStand;
    private Location armorStandLocation;
    private LivingEntity pigman;
    private Location pigmanLocation;

    public Animation4_Task(Main main, AnimationSettings animationSettings) {
        super(main, animationSettings);
    }

    @Override
    public void onTick(int n) {
        if (n == 45) {
            this.startRunnable("arch", 0L, 1L);
            this.startRunnable("archSounds", 0L, 5L);
        } else if (n == 95) {
            this.cancelRunnable("archSounds");
        } else if (n == 100) {
            this.startRunnable("music", 0L, 5L);
            this.armorStand = ASSpawner.spawn(this.getMain(), this.getCubeletBox(), this.getCubeletType(), false);
            this.armorStandLocation = this.armorStand.getLocation();
            this.getMain().getAnimationHandler().getEntities().add((Entity)this.armorStand);
        } else if (n > 100 && n < 140) {
            if (this.armorStand != null) {
                if (n < 139) {
                    this.armorStandLocation.add(0.0, 0.025, 0.0);
                }
                this.armorStand.teleport(this.armorStandLocation);
                this.armorStand.setHeadPose(this.armorStand.getHeadPose().add(0.0, 0.16, 0.0));
            }
        } else if (n == 145) {
            this.cancelRunnable("music");
            this.pigman = XMaterial.supports(16) ? (LivingEntity)this.getCubeletBox().getLocation().getWorld().spawnEntity(this.getLocationRotation(3.0), EntityType.valueOf((String)"ZOMBIFIED_PIGLIN")) : (LivingEntity)this.getCubeletBox().getLocation().getWorld().spawnEntity(this.getLocationRotation(3.0), EntityType.valueOf((String)"PIG_ZOMBIE"));
            this.pigman.setCollidable(false);
            ((PigZombie)this.pigman).setBaby(false);
            ((PigZombie)this.pigman).setAngry(false);
            this.pigman.setRemoveWhenFarAway(false);
            this.pigman.setMetadata("ACUBELETS", (MetadataValue)new FixedMetadataValue((Plugin)this.getMain(), (Object)Boolean.TRUE));
            NBTEditor.set(this.pigman, (byte)1, "Silent");
            NBTEditor.set(this.pigman, (byte)1, "Invulnerable");
            this.addRunnable("particles", new Animation4_3x3Particles(this.pigman));
            this.startRunnable("particles", 0L, 1L);
        } else if (n == 155) {
            NBTEditor.set(this.pigman, (byte)1, "NoAI");
            this.pigmanLocation = this.pigman.getLocation();
            this.pigmanLocation.setYaw(this.getCubeletBox().getRotation().value);
            this.pigmanLocation.setPitch(0.0f);
            this.pigman.teleport(this.pigmanLocation);
        } else if (n == 195) {
            this.addRunnable("entityPackets", new Animation4_EntityPackets(this.pigman, this.armorStand, this.getCubeletBox()));
            this.startRunnable("entityPackets", 0L, 5L);
        } else if (n == 293) {
            this.doPreRewardReveal();
        }
    }

    @Override
    public void onStart() {
        this.addRunnable("music", new Animation4_Music(this.getCubeletBox().getLocation()));
        this.setAnimationBlocks(new Animation4_Blocks(this.getCubeletBox().getLocation()));
        this.startAnimationBlocks(0L);
        this.addRunnable("arch", new Animation4_Arch(this.getCubeletBox().getLocation()));
        this.addRunnable("archSounds", new Animation4_ArchSounds(this.getCubeletBox().getLocation()));
        this.setColors(Arrays.asList(Color.RED, Color.RED));
    }

    @Override
    public void onStop() {
        this.stopAnimationBlocks();
        this.cancelRunnables();
        if (this.pigman != null) {
            this.pigman.remove();
        }
        if (this.getMain().getAnimationHandler().getEntities().contains(this.armorStand)) {
            if (this.armorStand != null) {
                this.armorStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(this.armorStand);
        }
    }

    @Override
    public void onPreRewardReveal() {
        this.getMain().getFireworkUtil().spawn(this.getCubeletBox().getLocation().clone().add(0.5, 1.5, 0.5), FireworkEffect.Type.BALL_LARGE, this.getColors().get(0), this.getColors().get(1));
    }

    @Override
    public void onRewardReveal() {
        this.pigman.remove();
        this.cancelRunnable("music");
        this.cancelRunnable("particles");
        this.cancelRunnable("entityPackets");
        Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.ZOMBIE_WOODBREAK, 0.5f, 1.0f);
        this.armorStand.remove();
        this.armorStand = null;
    }
}

