/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation9;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.ASSpawner;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.animations.animation.animation9.Animation9_Charge;
import me.davidml16.acubelets.animations.animation.animation9.Animation9_Music;
import me.davidml16.acubelets.utils.LocationUtils;
import me.davidml16.acubelets.utils.ParticlesAPI.Particles;
import me.davidml16.acubelets.utils.ParticlesAPI.UtilParticles;
import me.davidml16.acubelets.utils.Sounds;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class Animation9_Task
extends Animation {
    private ArmorStand armorStand;
    private double boxLocIncrease = -1.25;
    private double circleSize = 0.0;
    private int circleStep = 0;
    private float rotation;

    public Animation9_Task(Main main, AnimationSettings animationSettings) {
        super(main, animationSettings);
    }

    @Override
    public void onTick(int n) {
        if (n <= 25) {
            Location location = this.getBoxLocation().clone();
            this.boxLocIncrease += 0.05;
            location.add(0.0, this.boxLocIncrease, 0.0);
            location.setYaw(this.rotation);
            UtilParticles.display(Particles.FIREWORKS_SPARK, this.armorStand.getLocation().clone().add(0.0, 1.25, 0.0), 1);
            this.armorStand.teleport(location);
        } else if (n <= 60) {
            this.boxLocIncrease += 0.04;
            Location location = this.getBoxLocation().clone();
            location.add(0.0, this.boxLocIncrease, 0.0);
            this.circleSize = n <= 40 ? (this.circleSize += 0.07) : (this.circleSize -= 0.075);
            if (this.circleSize < 0.0) {
                this.circleSize = 0.0;
            }
            List<Location> list = LocationUtils.getCircle(location, this.circleSize, 50);
            Location location2 = list.get(this.circleStep).clone();
            location2.setYaw(this.rotation);
            Sounds.playSound(this.armorStand.getLocation(), Sounds.MySound.NOTE_PLING, 0.5f, 3.0f);
            UtilParticles.display(Particles.FIREWORKS_SPARK, this.armorStand.getLocation().clone().add(0.0, 1.25, 0.0), 1);
            this.armorStand.teleport(location2);
            ++this.circleStep;
            if (this.circleStep == list.size()) {
                this.circleStep = 0;
            }
        }
        if (n == 65) {
            this.chargeParticles();
        }
        if (n == 100) {
            this.cancelRunnable("music");
        }
        if (n == 105) {
            this.doPreRewardReveal();
        }
    }

    @Override
    public void onStart() {
        this.rotation = this.getRotation((boolean)false).value;
        this.armorStand = ASSpawner.spawn(this.getMain(), this.getCubeletBox(), this.getCubeletType(), false, false, this.getBoxLocation().clone().add(0.0, -1.25, 0.0));
        this.getMain().getAnimationHandler().getEntities().add((Entity)this.armorStand);
        this.addRunnable("music", new Animation9_Music(this.getCubeletBox().getLocation()));
        this.startRunnable("music", 5L, 3L);
        this.addRunnable("charge", new Animation9_Charge(this.getCubeletBox().getLocation()));
        this.startRunnable("charge", 65L, 3L);
        this.setColors(Arrays.asList(Color.BLACK, Color.ORANGE));
    }

    @Override
    public void onStop() {
        this.cancelRunnables();
        if (this.getMain().getAnimationHandler().getEntities().contains(this.armorStand)) {
            if (this.armorStand != null) {
                this.armorStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(this.armorStand);
        }
    }

    @Override
    public void onPreRewardReveal() {
        this.getMain().getFireworkUtil().spawn(this.armorStand.getLocation().clone().add(0.0, 1.75, 0.0), FireworkEffect.Type.BALL, this.getColors().get(0), this.getColors().get(1));
        Sounds.playSound(this.armorStand.getLocation(), Sounds.MySound.EXPLODE, 0.5f, 1.0f);
    }

    @Override
    public void onRewardReveal() {
        Sounds.playSound(this.armorStand.getLocation(), Sounds.MySound.LEVEL_UP, 0.5f, 1.0f);
    }

    private void chargeParticles() {
        Random random = new Random();
        Location location = this.armorStand.getLocation().clone().add(0.0, 3.0, 0.0);
        for (int i = 0; i < 500; ++i) {
            Location location2 = location.clone();
            location2.add((random.nextDouble() - 0.5) / 2.0, (new Random().nextDouble() - 0.5) / 2.0, (random.nextDouble() - 0.5) / 2.0);
            Vector vector = location2.toVector().subtract(location.toVector()).normalize();
            Vector vector2 = vector.multiply(1.5 + new Random().nextDouble() * 5.0);
            for (int j = 0; j < 3; ++j) {
                UtilParticles.display(Particles.ENCHANTMENT_TABLE, vector2, location, 5.0f);
            }
        }
    }
}

