/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.conversation.crafting;

import java.util.ArrayList;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.CommonPrompts;
import me.davidml16.acubelets.enums.CraftType;
import me.davidml16.acubelets.menus.admin.crafting.EditCraftingIngredientsMenu;
import me.davidml16.acubelets.objects.CraftIngredient;
import me.davidml16.acubelets.objects.CraftParent;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.FixedSetPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CraftIngredientCubeletConversation
implements ConversationAbandonedListener,
CommonPrompts {
    private Main main;

    public CraftIngredientCubeletConversation(Main main) {
        this.main = main;
    }

    public Conversation getConversation(Player player, CraftParent craftParent, CraftType craftType) {
        Conversation conversation = new ConversationFactory((Plugin)this.main).withModality(true).withLocalEcho(false).withFirstPrompt((Prompt)new RewardMenuOptions()).withTimeout(3600).thatExcludesNonPlayersWithMessage("").addConversationAbandonedListener((ConversationAbandonedListener)this).buildConversation((Conversable)player);
        conversation.getContext().setSessionData((Object)"player", (Object)player);
        conversation.getContext().setSessionData((Object)"craftParent", (Object)craftParent);
        conversation.getContext().setSessionData((Object)"craftType", (Object)craftType);
        this.main.getConversationHandler().addConversation(player);
        return conversation;
    }

    public void conversationAbandoned(ConversationAbandonedEvent conversationAbandonedEvent) {
    }

    public class RewardMenuOptions
    extends FixedSetPrompt {
        RewardMenuOptions() {
            super(new String[]{"1", "2", "3", "4"});
        }

        protected Prompt acceptValidatedInput(ConversationContext conversationContext, String string) {
            switch (string) {
                case "1": {
                    ArrayList<String> arrayList = new ArrayList<String>(CraftIngredientCubeletConversation.this.main.getCubeletTypesHandler().getTypes().keySet());
                    return new CommonPrompts.CommonStringPrompt(CraftIngredientCubeletConversation.this.main, (Prompt)this, false, ChatColor.YELLOW + "  Enter required cubelet, \"cancel\" to return.\n  Available cubelets: " + arrayList + "\n\n ", "cubeletType");
                }
                case "2": {
                    return new CommonPrompts.IntegerPrompt(CraftIngredientCubeletConversation.this.main, (Prompt)this, ChatColor.YELLOW + "  Enter required amount, \"cancel\" to return.\n\n ", "amount");
                }
                case "3": {
                    if (conversationContext.getSessionData((Object)"cubeletType") != null && conversationContext.getSessionData((Object)"amount") != null) {
                        String string2 = (String)conversationContext.getSessionData((Object)"cubeletType");
                        int n = (Integer)conversationContext.getSessionData((Object)"amount");
                        CraftParent craftParent = (CraftParent)conversationContext.getSessionData((Object)"craftParent");
                        CraftType craftType = (CraftType)((Object)conversationContext.getSessionData((Object)"craftType"));
                        CraftIngredient craftIngredient = new CraftIngredient(craftParent.getCubeletType(), craftType, string2, n);
                        craftParent.getIngrediens().add(craftIngredient);
                        CraftIngredientCubeletConversation.this.main.getCubeletCraftingHandler().saveCrafting();
                        conversationContext.getForWhom().sendRawMessage("\n" + Utils.translate(CraftIngredientCubeletConversation.this.main.getLanguageHandler().getPrefix() + " &aYou added a new ingredient for cubelet &e" + craftParent.getCubeletType()));
                        Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.ANVIL_USE, 10.0f, 3.0f);
                        CraftIngredientCubeletConversation.this.main.getMenuHandler().reloadAllMenus(EditCraftingIngredientsMenu.class);
                        Player player = (Player)conversationContext.getSessionData((Object)"player");
                        EditCraftingIngredientsMenu editCraftingIngredientsMenu = new EditCraftingIngredientsMenu(CraftIngredientCubeletConversation.this.main, player);
                        editCraftingIngredientsMenu.setAttribute(Menu.AttrType.CRAFT_PARENT_ATTR, craftParent);
                        editCraftingIngredientsMenu.open();
                        CraftIngredientCubeletConversation.this.main.getConversationHandler().removeConversation(player);
                        return Prompt.END_OF_CONVERSATION;
                    }
                    return new CommonPrompts.ErrorPrompt(CraftIngredientCubeletConversation.this.main, (Prompt)this, "\n" + ChatColor.RED + "  You need to setup cubeletType and Amount to save craft!\n  Write anything to continue\n ");
                }
                case "4": {
                    return new CommonPrompts.ConfirmExitPrompt(CraftIngredientCubeletConversation.this.main, (Prompt)this);
                }
            }
            return null;
        }

        public String getPromptText(ConversationContext conversationContext) {
            String string = "";
            string = string + ChatColor.GOLD + "" + ChatColor.BOLD + "\n  CUBELET INGREDIENT (CUBELET) CREATION MENU\n";
            string = string + ChatColor.GREEN + " \n";
            string = conversationContext.getSessionData((Object)"cubeletType") == null ? string + ChatColor.RED + "    1 " + ChatColor.GRAY + "- Set required cubelet (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    1 " + ChatColor.GRAY + "- Set required cubelet (" + ChatColor.YELLOW + conversationContext.getSessionData((Object)"cubeletType") + ChatColor.GRAY + ")\n";
            string = conversationContext.getSessionData((Object)"amount") == null ? string + ChatColor.RED + "    2 " + ChatColor.GRAY + "- Set required amount (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    2 " + ChatColor.GRAY + "- Set required amount (" + ChatColor.YELLOW + conversationContext.getSessionData((Object)"amount") + ChatColor.GRAY + ")\n";
            string = string + ChatColor.GREEN + "    3 " + ChatColor.GRAY + "- Save\n";
            string = string + ChatColor.GREEN + "    4 " + ChatColor.GRAY + "- Exit and discard\n";
            string = string + ChatColor.GREEN + " \n";
            string = string + ChatColor.GOLD + "" + ChatColor.YELLOW + "  Choose the option: \n";
            string = string + ChatColor.GREEN + " \n";
            return string;
        }
    }
}

