/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.conversation.crafting;

import java.util.ArrayList;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.CommonPrompts;
import me.davidml16.acubelets.menus.admin.crafting.EditCraftingCraftsMenu;
import me.davidml16.acubelets.objects.CraftParent;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.FixedSetPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CraftParentConversation
implements ConversationAbandonedListener,
CommonPrompts {
    private Main main;

    public CraftParentConversation(Main main) {
        this.main = main;
    }

    public Conversation getConversation(Player player) {
        Conversation conversation = new ConversationFactory((Plugin)this.main).withModality(true).withLocalEcho(false).withFirstPrompt((Prompt)new RewardMenuOptions()).withTimeout(3600).thatExcludesNonPlayersWithMessage("").addConversationAbandonedListener((ConversationAbandonedListener)this).buildConversation((Conversable)player);
        conversation.getContext().setSessionData((Object)"player", (Object)player);
        this.main.getConversationHandler().addConversation(player);
        return conversation;
    }

    public void conversationAbandoned(ConversationAbandonedEvent conversationAbandonedEvent) {
    }

    public class RewardMenuOptions
    extends FixedSetPrompt {
        RewardMenuOptions() {
            super(new String[]{"1", "2", "3", "4"});
        }

        protected Prompt acceptValidatedInput(ConversationContext conversationContext, String string) {
            switch (string) {
                case "1": {
                    ArrayList<String> arrayList = new ArrayList<String>(CraftParentConversation.this.main.getCubeletTypesHandler().getTypes().keySet());
                    return new CommonPrompts.CommonStringPrompt(CraftParentConversation.this.main, (Prompt)this, false, ChatColor.YELLOW + "  Enter crafted cubelet, \"cancel\" to return.\n  Available cubelets: " + arrayList + "\n\n ", "cubeletType");
                }
                case "2": {
                    return new CommonPrompts.NumericIntegerRangePrompt(CraftParentConversation.this.main, (Prompt)this, ChatColor.YELLOW + "  Enter craft icon slot, \"cancel\" to return.\n  Range: 0 to " + (CraftParentConversation.this.main.getCubeletCraftingHandler().getInventoryRows() - 1) * 9 + "\n\n ", "slot", 0, (CraftParentConversation.this.main.getCubeletCraftingHandler().getInventoryRows() - 1) * 9);
                }
                case "3": {
                    if (conversationContext.getSessionData((Object)"cubeletType") != null && conversationContext.getSessionData((Object)"slot") != null) {
                        String string2 = (String)conversationContext.getSessionData((Object)"cubeletType");
                        if (CraftParentConversation.this.main.getCubeletTypesHandler().getTypeBydId(string2) == null) {
                            return new CommonPrompts.ErrorPrompt(CraftParentConversation.this.main, (Prompt)this, "\n" + ChatColor.RED + "  The crafted cubelet type not exists!\n  Write anything to continue\n ");
                        }
                        int n = (Integer)conversationContext.getSessionData((Object)"slot");
                        CraftParent craftParent = new CraftParent(string2, n);
                        CraftParentConversation.this.main.getCubeletCraftingHandler().getCrafts().add(craftParent);
                        CraftParentConversation.this.main.getCubeletCraftingHandler().saveCrafting();
                        conversationContext.getForWhom().sendRawMessage("\n" + Utils.translate(CraftParentConversation.this.main.getLanguageHandler().getPrefix() + " &aYou added craft for the cubelet &e" + craftParent.getCubeletType()));
                        Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.ANVIL_USE, 10.0f, 3.0f);
                        CraftParentConversation.this.main.getMenuHandler().reloadAllMenus(EditCraftingCraftsMenu.class);
                        Player player = (Player)conversationContext.getSessionData((Object)"player");
                        new EditCraftingCraftsMenu(CraftParentConversation.this.main, player).open();
                        CraftParentConversation.this.main.getConversationHandler().removeConversation(player);
                        return Prompt.END_OF_CONVERSATION;
                    }
                    return new CommonPrompts.ErrorPrompt(CraftParentConversation.this.main, (Prompt)this, "\n" + ChatColor.RED + "  You need to setup cubeletType and Slot to save craft!\n  Write anything to continue\n ");
                }
                case "4": {
                    return new CommonPrompts.ConfirmExitPrompt(CraftParentConversation.this.main, (Prompt)this);
                }
            }
            return null;
        }

        public String getPromptText(ConversationContext conversationContext) {
            String string = "";
            string = string + ChatColor.GOLD + "" + ChatColor.BOLD + "\n  CUBELET CRAFT CREATION MENU\n";
            string = string + ChatColor.GREEN + " \n";
            string = conversationContext.getSessionData((Object)"cubeletType") == null ? string + ChatColor.RED + "    1 " + ChatColor.GRAY + "- Set crafted cubelet (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    1 " + ChatColor.GRAY + "- Set crafted cubelet (" + ChatColor.YELLOW + conversationContext.getSessionData((Object)"cubeletType") + ChatColor.GRAY + ")\n";
            string = conversationContext.getSessionData((Object)"slot") == null ? string + ChatColor.RED + "    2 " + ChatColor.GRAY + "- Set craft icon slot (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    2 " + ChatColor.GRAY + "- Set craft icon slot (" + ChatColor.YELLOW + conversationContext.getSessionData((Object)"slot") + ChatColor.GRAY + ")\n";
            string = string + ChatColor.GREEN + "    3 " + ChatColor.GRAY + "- Save\n";
            string = string + ChatColor.GREEN + "    4 " + ChatColor.GRAY + "- Exit and discard\n";
            string = string + ChatColor.GREEN + " \n";
            string = string + ChatColor.GOLD + "" + ChatColor.YELLOW + "  Choose the option: \n";
            string = string + ChatColor.GREEN + " \n";
            return string;
        }
    }
}

