/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.database.types.DatabaseConnection;
import me.davidml16.acubelets.database.types.MySqlConnection;
import me.davidml16.acubelets.database.types.SQLiteConnection;
import me.davidml16.acubelets.objects.Cubelet;
import me.davidml16.acubelets.objects.Profile;
import me.davidml16.acubelets.objects.loothistory.LootHistory;
import me.davidml16.acubelets.objects.loothistory.RewardHistory;
import me.davidml16.acubelets.utils.ItemStack64;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DatabaseHandler {
    private DatabaseConnection databaseConnection;
    private Main main;

    public DatabaseHandler(Main main) {
        this.main = main;
        this.databaseConnection = main.getConfig().getBoolean("MySQL.Enabled") ? new MySqlConnection(main) : new SQLiteConnection(main);
    }

    public void openConnection() {
        Main.log.sendMessage(Utils.translate("  "));
        Main.log.sendMessage(Utils.translate("  &eLoading database:"));
        this.databaseConnection.open();
    }

    public void changeToSQLite() {
        this.databaseConnection = new SQLiteConnection(this.main);
        this.databaseConnection.open();
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.databaseConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(String string) {
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.databaseConnection.getConnection();
            statement = connection.prepareStatement(string);
            statement.execute();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            this.databaseConnection.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQueryError(String string) {
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.databaseConnection.getConnection();
            statement = connection.prepareStatement(string);
            statement.execute();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            this.databaseConnection.close(connection);
        }
    }

    public void loadTables() {
        this.executeQuery("CREATE TABLE IF NOT EXISTS ac_cubelets (`UUID` varchar(40) NOT NULL, `cubeletUUID` varchar(40) NOT NULL, `type` VARCHAR(15) NOT NULL, `received` bigint NOT NULL DEFAULT 0, `expire` bigint NOT NULL DEFAULT 0, PRIMARY KEY (`UUID`, `cubeletUUID`));");
        this.executeQuery("CREATE TABLE IF NOT EXISTS ac_players (`UUID` varchar(40) NOT NULL, `NAME` varchar(40), `LOOT_POINTS` integer(25), `ORDER_BY` varchar(10), `ANIMATION` varchar(25), PRIMARY KEY (`UUID`));");
        try {
            this.executeQueryError("CREATE TABLE IF NOT EXISTS ac_loothistory (`ID` INTEGER PRIMARY KEY AUTO_INCREMENT, `UUID` varchar(40) NOT NULL, `cubeletName` varchar(50) NOT NULL, `rewardID` varchar(50) NOT NULL, `rewardName` varchar(255) NOT NULL, `rewardIcon` LONGTEXT NOT NULL, `received` bigint NOT NULL DEFAULT 0);");
        }
        catch (SQLException sQLException) {
            try {
                this.executeQueryError("CREATE TABLE IF NOT EXISTS ac_loothistory (`ID` INTEGER PRIMARY KEY AUTOINCREMENT, `UUID` varchar(40) NOT NULL, `cubeletName` varchar(50) NOT NULL, `rewardID` varchar(50) NOT NULL, `rewardName` varchar(255) NOT NULL, `rewardIcon` LONGTEXT NOT NULL, `received` bigint NOT NULL DEFAULT 0);");
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
            }
        }
        try {
            this.executeQueryError("ALTER TABLE ac_loothistory MODIFY rewardName VARCHAR(255)");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void hasName(String string, Callback<String> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            ResultSet resultSet = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("SELECT * FROM ac_players WHERE LOWER(NAME) = '" + string.toLowerCase() + "';");
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    callback.done(resultSet.getString("NAME"));
                } else {
                    callback.done(null);
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void createPlayerData(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("INSERT INTO ac_players (UUID,NAME,LOOT_POINTS,ORDER_BY,ANIMATION) VALUES(?,?,?,?,?)");
                statement.setString(1, player.getUniqueId().toString());
                statement.setString(2, player.getName());
                statement.setLong(3, 0L);
                statement.setString(4, "date");
                statement.setString(5, "animation2");
                statement.executeUpdate();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void getPlayerAnimation(UUID uUID, Callback<String> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            ResultSet resultSet = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("SELECT * FROM ac_players WHERE UUID = '" + uUID + "';");
                resultSet = statement.executeQuery();
                String string = "animation2";
                if (resultSet.next()) {
                    string = resultSet.getString("ANIMATION");
                }
                String string2 = string;
                Bukkit.getScheduler().runTask((Plugin)this.main, () -> callback.done(string2));
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void setPlayerAnimation(UUID uUID, String string) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("UPDATE ac_players SET `ANIMATION` = ? WHERE `UUID` = ?");
                statement.setString(1, string);
                statement.setString(2, uUID.toString());
                statement.executeUpdate();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void getPlayerOrderSetting(UUID uUID, Callback<String> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            ResultSet resultSet = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("SELECT * FROM ac_players WHERE UUID = '" + uUID + "';");
                resultSet = statement.executeQuery();
                String string = "date";
                if (resultSet.next()) {
                    string = resultSet.getString("ORDER_BY");
                }
                String string2 = string;
                Bukkit.getScheduler().runTask((Plugin)this.main, () -> callback.done(string2));
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void getPlayerLootPoints(UUID uUID, Callback<Long> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            ResultSet resultSet = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("SELECT * FROM ac_players WHERE UUID = '" + uUID + "';");
                resultSet = statement.executeQuery();
                long l = 0L;
                if (resultSet.next()) {
                    l = resultSet.getLong("LOOT_POINTS");
                }
                long l2 = l;
                Bukkit.getScheduler().runTask((Plugin)this.main, () -> callback.done(l2));
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void setPlayerOrderSetting(UUID uUID, String string) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("UPDATE ac_players SET `ORDER_BY` = ? WHERE `UUID` = ?");
                statement.setString(1, string);
                statement.setString(2, uUID.toString());
                statement.executeUpdate();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void setPlayerLootPoints(UUID uUID, long l) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("UPDATE ac_players SET `LOOT_POINTS` = ? WHERE `UUID` = ?");
                statement.setLong(1, l);
                statement.setString(2, uUID.toString());
                statement.executeUpdate();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void saveProfileAsync(Profile profile) {
        if (profile == null) {
            return;
        }
        String string = Bukkit.getPlayer((UUID)profile.getUuid()).getName();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("UPDATE ac_players SET `NAME` = ?, `LOOT_POINTS` = ?, `ORDER_BY` = ?, `ANIMATION` = ? WHERE `UUID` = ?");
                statement.setString(1, string);
                statement.setLong(2, profile.getLootPoints());
                statement.setString(3, profile.getOrderBy());
                statement.setString(4, profile.getAnimation());
                statement.setString(5, profile.getUuid().toString());
                statement.executeUpdate();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProfileSync(Profile profile) {
        if (profile == null) {
            return;
        }
        String string = Bukkit.getPlayer((UUID)profile.getUuid()).getName();
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.databaseConnection.getConnection();
            statement = connection.prepareStatement("UPDATE ac_players SET `NAME` = ?, `LOOT_POINTS` = ?, `ORDER_BY` = ?, `ANIMATION` = ? WHERE `UUID` = ?");
            statement.setString(1, string);
            statement.setLong(2, profile.getLootPoints());
            statement.setString(3, profile.getOrderBy());
            statement.setString(4, profile.getAnimation());
            statement.setString(5, profile.getUuid().toString());
            statement.executeUpdate();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            this.databaseConnection.close(connection);
        }
    }

    public void updatePlayerName(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("UPDATE ac_players SET `NAME` = ? WHERE `UUID` = ?");
                statement.setString(1, player.getName());
                statement.setString(2, player.getUniqueId().toString());
                statement.executeUpdate();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void getPlayerUUID(String string, Callback<String> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            ResultSet resultSet = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("SELECT * FROM ac_players WHERE LOWER(NAME) = '" + string.toLowerCase() + "';");
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    String string2 = resultSet.getString("UUID");
                    Bukkit.getScheduler().runTask((Plugin)this.main, () -> callback.done(string2));
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void addCubelet(UUID uUID, String string, Long l, Long l2) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("INSERT INTO ac_cubelets (UUID,cubeletUUID,type,received,expire) VALUES(?,?,?,?,?)");
                statement.setString(1, uUID.toString());
                statement.setString(2, UUID.randomUUID().toString());
                statement.setString(3, string);
                statement.setLong(4, l);
                statement.setLong(5, l2);
                statement.executeUpdate();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void addCubelet(UUID uUID, UUID uUID2, String string, Long l, Long l2) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("INSERT INTO ac_cubelets (UUID,cubeletUUID,type,received,expire) VALUES(?,?,?,?,?)");
                statement.setString(1, uUID.toString());
                statement.setString(2, uUID2.toString());
                statement.setString(3, string);
                statement.setLong(4, l);
                statement.setLong(5, l2);
                statement.executeUpdate();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void addCubelets(UUID uUID, Collection<Cubelet> collection) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Object object2;
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object2 : collection) {
                if (stringBuilder.toString().equalsIgnoreCase("")) {
                    stringBuilder.append("('").append(uUID.toString()).append("','").append(((Cubelet)object2).getUuid()).append("','").append(((Cubelet)object2).getType()).append("',").append(((Cubelet)object2).getReceived()).append(",").append(((Cubelet)object2).getExpire()).append(")");
                    continue;
                }
                stringBuilder.append(", ('").append(uUID.toString()).append("','").append(((Cubelet)object2).getUuid()).append("','").append(((Cubelet)object2).getType()).append("',").append(((Cubelet)object2).getReceived()).append(",").append(((Cubelet)object2).getExpire()).append(")");
            }
            Object object3 = null;
            object2 = null;
            try {
                object2 = this.databaseConnection.getConnection();
                object3 = object2.prepareStatement("INSERT INTO ac_cubelets (UUID,cubeletUUID,type,received,expire) VALUES " + stringBuilder.toString());
                object3.executeUpdate();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (object3 != null) {
                    try {
                        object3.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close((Connection)object2);
            }
        });
    }

    public void removeCubelet(UUID uUID, UUID uUID2) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("DELETE FROM ac_cubelets WHERE UUID = '" + uUID + "' AND cubeletUUID = '" + uUID2 + "';");
                statement.execute();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void removeCubelet(UUID uUID, String string, int n) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("DELETE FROM ac_cubelets WHERE rowid IN (SELECT rowid FROM ac_cubelets WHERE UUID = '" + uUID + "' AND type = '" + string + "' LIMIT " + n + ");");
                statement.execute();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void removeCubelets(UUID uUID, Collection<Cubelet> collection) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Object object2;
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object2 : collection) {
                if (stringBuilder.toString().equalsIgnoreCase("")) {
                    stringBuilder.append("'").append(((Cubelet)object2).getUuid().toString()).append("'");
                    continue;
                }
                stringBuilder.append(",'").append(((Cubelet)object2).getUuid().toString()).append("'");
            }
            Object object3 = null;
            object2 = null;
            try {
                object2 = this.databaseConnection.getConnection();
                object3 = object2.prepareStatement("DELETE FROM ac_cubelets WHERE UUID = '" + uUID + "' AND cubeletUUID IN (" + stringBuilder + ");");
                object3.execute();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (object3 != null) {
                    try {
                        object3.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close((Connection)object2);
            }
        });
    }

    public void removeCubelets(UUID uUID) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("DELETE FROM ac_cubelets WHERE UUID = '" + uUID + "';");
                statement.execute();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void removeCubelet(String string) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("DELETE FROM ac_cubelets WHERE type = '" + string + "';");
                statement.execute();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void removeExpiredCubelets(UUID uUID) {
        long l = System.currentTimeMillis();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("DELETE FROM ac_cubelets WHERE UUID = '" + uUID + "' AND expire < '" + l + "';");
                statement.execute();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void getCubeletBalance(UUID uUID, String string, Callback<Long> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            ResultSet resultSet = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("SELECT COUNT(*) AS amount FROM ac_cubelets WHERE UUID = '" + uUID.toString() + "' AND type = '" + string + "';");
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    Long l = resultSet.getInt("amount");
                    Bukkit.getScheduler().runTask((Plugin)this.main, () -> callback.done(l));
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public CompletableFuture<List<Cubelet>> getCubelets(UUID uUID) {
        CompletableFuture<List<Cubelet>> completableFuture = new CompletableFuture<List<Cubelet>>();
        long l = System.currentTimeMillis();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            ArrayList<Cubelet> arrayList = new ArrayList<Cubelet>();
            Statement statement = null;
            ResultSet resultSet = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("SELECT * FROM ac_cubelets WHERE UUID = '" + uUID.toString() + "' AND expire > '" + l + "';");
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    if (!this.main.getCubeletTypesHandler().getTypes().containsKey(resultSet.getString("type"))) continue;
                    arrayList.add(new Cubelet(UUID.fromString(resultSet.getString("cubeletUUID")), resultSet.getString("type"), resultSet.getLong("received"), resultSet.getLong("expire")));
                }
                completableFuture.complete(arrayList);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<List<LootHistory>> getLootHistory(UUID uUID) {
        CompletableFuture<List<LootHistory>> completableFuture = new CompletableFuture<List<LootHistory>>();
        long l = System.currentTimeMillis();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            ArrayList<LootHistory> arrayList = new ArrayList<LootHistory>();
            Statement statement = null;
            ResultSet resultSet = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("SELECT * FROM ac_loothistory WHERE UUID = '" + uUID.toString() + "';");
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    int n = resultSet.getInt("ID");
                    String string = resultSet.getString("UUID");
                    String string2 = resultSet.getString("cubeletName");
                    long l = resultSet.getLong("received");
                    String string3 = resultSet.getString("rewardID");
                    String string4 = resultSet.getString("rewardName");
                    String string5 = resultSet.getString("rewardIcon");
                    RewardHistory rewardHistory = new RewardHistory(UUID.fromString(string3), string4, string5);
                    arrayList.add(new LootHistory(n, UUID.fromString(string), string2, l, rewardHistory));
                }
                completableFuture.complete(arrayList);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
        return completableFuture;
    }

    public void addLootHistory(UUID uUID, LootHistory lootHistory) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Connection connection;
            Statement statement;
            block12: {
                statement = null;
                connection = null;
                try {
                    String string = ItemStack64.itemStackToBase64(lootHistory.getRewardHistory().getItemStack());
                    String string2 = "('" + uUID.toString() + "','" + lootHistory.getCubeletName() + "','" + lootHistory.getRewardHistory().getUUID() + "','" + lootHistory.getRewardHistory().getName() + "','" + string + "'," + lootHistory.getReceived() + ")";
                    connection = this.databaseConnection.getConnection();
                    statement = connection.prepareStatement("INSERT INTO ac_loothistory (UUID,cubeletName,rewardID,rewardName,rewardIcon,received) VALUES " + string2);
                    statement.executeUpdate();
                    if (statement == null) break block12;
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    return;
                }
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            this.databaseConnection.close(connection);
            return;
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public void removeLootHistory(UUID uUID) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = this.databaseConnection.getConnection();
                statement = connection.prepareStatement("DELETE FROM ac_loothistory WHERE UUID = '" + uUID.toString() + "';");
                statement.execute();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                this.databaseConnection.close(connection);
            }
        });
    }

    public static interface Callback<T> {
        public void done(T var1);
    }
}

