/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.effects;

import me.davidml16.acubelets.effects.SimpleParticle;
import me.davidml16.acubelets.utils.LocationUtils;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public abstract class MachineEffect {
    protected int step = 0;
    protected long interval;
    protected int duration;
    protected int count = 0;
    protected int waitReset;

    public MachineEffect(long l, int n, int n2) {
        this.interval = l;
        this.duration = n;
        this.waitReset = n2;
    }

    public void reset() {
        this.step = 0;
        this.count = 0;
    }

    public void addStep() {
        if (++this.step > this.getDuration()) {
            this.reset();
        }
    }

    public void step(@NotNull Location location, @NotNull SimpleParticle simpleParticle) {
        if (this.step < 0) {
            return;
        }
        this.doStep(LocationUtils.getCenter(location.clone(), false), simpleParticle, this.step);
        if (this.step >= this.getDuration()) {
            this.step = this.waitReset;
            this.count = 0;
        }
    }

    public abstract void doStep(@NotNull Location var1, @NotNull SimpleParticle var2, int var3);

    public final long getInterval() {
        return this.interval;
    }

    public final int getDuration() {
        return this.duration;
    }
}

