/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.effects.implementations;

import me.davidml16.acubelets.effects.MachineEffect;
import me.davidml16.acubelets.effects.Point3d;
import me.davidml16.acubelets.effects.SimpleParticle;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class MachineSphereEffect
extends MachineEffect {
    private static final double DELTA_ANGLE = 0.3141592653589793;
    private static final int NUM_CIRCLES = 8;
    private static final int NUM_POINTS = 10;

    public MachineSphereEffect() {
        super(1L, 8, -10);
    }

    public static Point3d[] getCircleCoordinates(double d, int n) {
        Point3d[] point3dArray = new Point3d[10];
        double d2 = (double)n * 0.3141592653589793;
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        for (int i = 0; i < 10; ++i) {
            double d5 = (double)i * 2.0 * Math.PI / 10.0;
            double d6 = d * Math.cos(d5) * d3;
            double d7 = d * Math.sin(d5) * d3;
            double d8 = d * d4;
            point3dArray[i] = new Point3d(d6, d7, d8);
        }
        return point3dArray;
    }

    @Override
    public void doStep(@NotNull Location location, @NotNull SimpleParticle simpleParticle, int n) {
        Point3d[] point3dArray = MachineSphereEffect.getCircleCoordinates(1.0, n);
        for (int i = 0; i < 10; ++i) {
            Point3d point3d = point3dArray[i];
            simpleParticle.play(location.clone().add(point3d.x, point3d.z + 0.2, point3d.y), 0.0, 0.0, 1);
        }
    }
}

