/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.events;

import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.List;
import java.util.Optional;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.interfaces.CubeletDateComparator;
import me.davidml16.acubelets.menus.player.CubeletsMenu;
import me.davidml16.acubelets.menus.player.rewards.RewardsPreviewMenu;
import me.davidml16.acubelets.objects.Cubelet;
import me.davidml16.acubelets.objects.CubeletMachine;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.Profile;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Event_Interact
implements Listener {
    private Main main;

    public Event_Interact(Main main) {
        this.main = main;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        Action action = playerInteractEvent.getAction();
        ItemStack itemStack = playerInteractEvent.getItem();
        if ((action == Action.RIGHT_CLICK_AIR || action == Action.LEFT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK || action == Action.LEFT_CLICK_BLOCK) && itemStack != null && NBTEditor.contains(itemStack, "keyType")) {
            playerInteractEvent.setCancelled(true);
        }
        if (itemStack == null || !NBTEditor.contains(itemStack, "keyType") || !this.main.isKeysEnabled()) {
            if ((action == Action.RIGHT_CLICK_BLOCK || action == Action.LEFT_CLICK_BLOCK) && this.main.getCubeletBoxHandler().getBoxes().containsKey(playerInteractEvent.getClickedBlock().getLocation())) {
                playerInteractEvent.setCancelled(true);
                if (playerInteractEvent.getHand() != EquipmentSlot.HAND) {
                    return;
                }
                CubeletMachine cubeletMachine = this.main.getCubeletBoxHandler().getBoxByLocation(playerInteractEvent.getClickedBlock().getLocation());
                if (cubeletMachine.isWaiting()) {
                    this.main.getPlayerDataHandler().getData(player).setBoxOpened(cubeletMachine);
                    if (!this.main.isNoGuiMode()) {
                        new CubeletsMenu(this.main, player).open();
                    } else {
                        CubeletType cubeletType;
                        Cubelet cubelet;
                        Profile profile = this.main.getPlayerDataHandler().getData(player.getUniqueId());
                        List<Cubelet> list = profile.getCubelets();
                        list.sort(new CubeletDateComparator());
                        Optional optional = list.stream().findFirst();
                        if (optional.isPresent() && (cubelet = (Cubelet)optional.get()).getExpire() > System.currentTimeMillis() && (cubeletType = this.main.getCubeletTypesHandler().getTypeBydId(cubelet.getType())).getAllRewards().size() > 0) {
                            this.main.getCubeletOpenHandler().openAnimation(player, profile.getBoxOpened(), cubeletType, false);
                            this.main.getDatabaseHandler().removeCubelet(player.getUniqueId(), cubelet.getUuid());
                            profile.getCubelets().remove(cubelet);
                            this.main.getHologramImplementation().reloadHolograms(player);
                        }
                    }
                } else if (cubeletMachine.getPlayerOpening().getUuid() == player.getUniqueId()) {
                    player.sendMessage(this.main.getLanguageHandler().getMessage("Cubelet.BoxInUse.Me"));
                } else {
                    player.sendMessage(this.main.getLanguageHandler().getMessage("Cubelet.BoxInUse.Other").replaceAll("%player%", cubeletMachine.getPlayerOpening().getName()));
                }
            }
        } else if ((action == Action.RIGHT_CLICK_BLOCK || action == Action.LEFT_CLICK_BLOCK) && this.main.getCubeletBoxHandler().getBoxes().containsKey(playerInteractEvent.getClickedBlock().getLocation())) {
            playerInteractEvent.setCancelled(true);
            if (playerInteractEvent.getHand() != EquipmentSlot.HAND) {
                return;
            }
            String string = NBTEditor.getString(itemStack, "keyType");
            if (action == Action.LEFT_CLICK_BLOCK) {
                if (this.main.isPreviewEnabled()) {
                    RewardsPreviewMenu rewardsPreviewMenu = new RewardsPreviewMenu(Main.get(), player);
                    rewardsPreviewMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, string);
                    rewardsPreviewMenu.setAttribute(Menu.AttrType.OPENED_EXTERNALLY_ATTR, Boolean.TRUE);
                    rewardsPreviewMenu.open();
                }
            } else {
                CubeletMachine cubeletMachine = this.main.getCubeletBoxHandler().getBoxByLocation(playerInteractEvent.getClickedBlock().getLocation());
                if (cubeletMachine.isWaiting()) {
                    CubeletType cubeletType = this.main.getCubeletTypesHandler().getTypeBydId(string);
                    if (cubeletType.getAllRewards().size() > 0) {
                        this.main.getCubeletOpenHandler().openAnimation(player, cubeletMachine, cubeletType, true);
                        itemStack.setAmount(itemStack.getAmount() - 1);
                        Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> player.updateInventory(), 20L);
                        this.main.getHologramImplementation().reloadHolograms(player);
                    }
                } else if (cubeletMachine.getPlayerOpening().getUuid() == player.getUniqueId()) {
                    player.sendMessage(this.main.getLanguageHandler().getMessage("Cubelet.BoxInUse.Me"));
                } else {
                    player.sendMessage(this.main.getLanguageHandler().getMessage("Cubelet.BoxInUse.Other").replaceAll("%player%", cubeletMachine.getPlayerOpening().getName()));
                }
            }
        }
    }

    @EventHandler
    public void onArmorStand(PlayerArmorStandManipulateEvent playerArmorStandManipulateEvent) {
        ArmorStand armorStand = playerArmorStandManipulateEvent.getRightClicked();
        if (!armorStand.hasMetadata("ACUBELETS")) {
            return;
        }
        playerArmorStandManipulateEvent.setCancelled(true);
    }
}

