/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.handlers;

import com.cryptomorin.xseries.XItemStack;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.menus.player.LootHistoryMenu;
import me.davidml16.acubelets.objects.CubeletMachine;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Profile;
import me.davidml16.acubelets.objects.Rarity;
import me.davidml16.acubelets.objects.loothistory.LootHistory;
import me.davidml16.acubelets.objects.loothistory.RewardHistory;
import me.davidml16.acubelets.objects.rewards.CommandObject;
import me.davidml16.acubelets.objects.rewards.ItemObject;
import me.davidml16.acubelets.objects.rewards.PermissionObject;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.ItemStack64;
import me.davidml16.acubelets.utils.MessageUtils;
import me.davidml16.acubelets.utils.RepeatingTask;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CubeletRewardHandler {
    private Main main;

    public CubeletRewardHandler(Main main) {
        this.main = main;
    }

    public void loadRewards() {
        for (CubeletType cubeletType : this.main.getCubeletTypesHandler().getTypes().values()) {
            this.loadReward(cubeletType);
        }
    }

    public void loadReward(CubeletType cubeletType) {
        FileConfiguration fileConfiguration = this.main.getCubeletTypesHandler().getConfig(cubeletType.getId());
        HashMap<String, List<Reward>> hashMap = new HashMap<String, List<Reward>>();
        int n = 0;
        if (fileConfiguration.contains("type.rewards") && fileConfiguration.getConfigurationSection("type.rewards") != null) {
            int n2 = 0;
            for (String string : fileConfiguration.getConfigurationSection("type.rewards").getKeys(false)) {
                if (!this.validRewardData(fileConfiguration, string)) continue;
                String string2 = fileConfiguration.getString("type.rewards." + string + ".rarity");
                if (!cubeletType.getRarities().containsKey(string2)) continue;
                String string3 = fileConfiguration.getString("type.rewards." + string + ".name");
                ItemStack itemStack = null;
                if (fileConfiguration.get("type.rewards." + string + ".icon") instanceof MemorySection) {
                    itemStack = XItemStack.deserialize(Utils.getConfigurationSection((Configuration)fileConfiguration, "type.rewards." + string + ".icon"));
                } else {
                    try {
                        itemStack = ItemStack64.itemStackFromBase64(fileConfiguration.getString("type.rewards." + string + ".icon"));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                try {
                    itemStack = NBTEditor.set(itemStack, "reward_" + n2, "rewardID");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                    continue;
                }
                List list = hashMap.get(string2) == null ? new ArrayList() : (List)hashMap.get(string2);
                ArrayList<CommandObject> arrayList = new ArrayList<CommandObject>();
                ArrayList<PermissionObject> arrayList2 = new ArrayList<PermissionObject>();
                ArrayList<ItemObject> arrayList3 = new ArrayList<ItemObject>();
                if (fileConfiguration.contains("type.rewards." + string + ".command")) {
                    this.getRewardCommands(fileConfiguration, arrayList, string);
                }
                if (fileConfiguration.contains("type.rewards." + string + ".permission")) {
                    this.getRewardPermissions(fileConfiguration, arrayList2, string);
                }
                if (fileConfiguration.contains("type.rewards." + string + ".item")) {
                    this.getRewardItems(fileConfiguration, arrayList3, string);
                }
                Reward reward = new Reward("reward_" + n2, string3, cubeletType.getRarities().get(string2), itemStack, cubeletType);
                reward.setCommands(arrayList);
                reward.setPermissions(arrayList2);
                reward.setItems(arrayList3);
                if (fileConfiguration.contains("type.rewards." + string + ".rewardUUID")) {
                    reward.setRewardUUID(UUID.fromString(fileConfiguration.getString("type.rewards." + string + ".rewardUUID")));
                }
                reward.setBypassDuplicationSystem(fileConfiguration.getBoolean("type.rewards." + string + ".bypassDuplicationSystem", false));
                list.add(reward);
                hashMap.put(string2, list);
                ++n2;
                ++n;
            }
        }
        cubeletType.setRewards(hashMap);
        cubeletType.saveType();
    }

    private void getRewardCommands(FileConfiguration fileConfiguration, List<CommandObject> list, String string) {
        int n = 0;
        if (fileConfiguration.get("type.rewards." + string + ".command") instanceof ArrayList) {
            for (String string2 : fileConfiguration.getStringList("type.rewards." + string + ".command")) {
                list.add(new CommandObject("command-" + n, string2));
                ++n;
            }
        } else {
            list.add(new CommandObject("command-" + n, fileConfiguration.getString("type.rewards." + string + ".command")));
        }
    }

    private void getRewardPermissions(FileConfiguration fileConfiguration, List<PermissionObject> list, String string) {
        int n = 0;
        if (fileConfiguration.get("type.rewards." + string + ".permission") instanceof ArrayList) {
            for (String string2 : fileConfiguration.getStringList("type.rewards." + string + ".permission")) {
                list.add(new PermissionObject("permission-" + n, string2));
                ++n;
            }
        } else {
            list.add(new PermissionObject("permission-" + n, fileConfiguration.getString("type.rewards." + string + ".permission")));
        }
    }

    private void getRewardItems(FileConfiguration fileConfiguration, List<ItemObject> list, String string) {
        int n = 0;
        if (fileConfiguration.contains("type.rewards." + string + ".item") && fileConfiguration.getConfigurationSection("type.rewards." + string + ".item") != null) {
            for (String string2 : fileConfiguration.getConfigurationSection("type.rewards." + string + ".item").getKeys(false)) {
                if (fileConfiguration.get("type.rewards." + string + ".item." + string2) instanceof MemorySection) {
                    list.add(new ItemObject("item-" + n, XItemStack.deserialize(Utils.getConfigurationSection((Configuration)fileConfiguration, "type.rewards." + string + ".item." + string2))));
                } else {
                    try {
                        list.add(new ItemObject("item-" + n, ItemStack64.itemStackFromBase64(fileConfiguration.getString("type.rewards." + string + ".item." + string2))));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                ++n;
            }
        }
    }

    private boolean validRewardData(FileConfiguration fileConfiguration, String string) {
        return fileConfiguration.contains("type.rewards." + string + ".name") && fileConfiguration.contains("type.rewards." + string + ".rarity") && fileConfiguration.contains("type.rewards." + string + ".icon");
    }

    public Reward processReward(CubeletType cubeletType) {
        List<Rarity> list = this.getAvailableRarities(cubeletType);
        Rarity rarity = this.chooseOnWeight(list);
        if (cubeletType.getRewards().containsKey(rarity.getId())) {
            List<Reward> list2 = cubeletType.getRewards().get(rarity.getId());
            if (list2.size() <= 0) {
                return this.processReward(cubeletType);
            }
            int n = ThreadLocalRandom.current().nextInt(list2.size()) % list2.size();
            return list2.get(n);
        }
        return null;
    }

    public void giveReward(CubeletMachine cubeletMachine, CubeletType cubeletType, Reward reward) {
        UUID uUID = cubeletMachine.getPlayerOpening().getUuid();
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (this.main.isBroadcastEnabled()) {
            MessageUtils.sendBroadcastMessage(this.main, cubeletMachine, cubeletType, reward);
        }
        RewardHistory rewardHistory = new RewardHistory(reward.getRewardUUID(), reward.getName(), reward.getIcon());
        LootHistory lootHistory = new LootHistory(uUID, cubeletType.getName(), System.currentTimeMillis(), rewardHistory);
        if (this.main.isDuplicationEnabled() && this.isDuplicated(cubeletMachine, reward)) {
            Bukkit.getServer().dispatchCommand((CommandSender)this.main.getServer().getConsoleSender(), this.main.getDuplicationPointsCommand().replaceAll("%player%", cubeletMachine.getPlayerOpening().getName()).replaceAll("%points%", "" + cubeletMachine.getLastDuplicationPoints()));
            MessageUtils.sendLootMessage(cubeletMachine, cubeletType, reward);
            this.main.getDatabaseHandler().addLootHistory(uUID, lootHistory);
            if (player != null) {
                Profile profile = this.main.getPlayerDataHandler().getData(player);
                profile.getLootHistory().add(lootHistory);
            }
            return;
        }
        for (CommandObject object : reward.getCommands()) {
            Bukkit.getServer().dispatchCommand((CommandSender)this.main.getServer().getConsoleSender(), object.getCommand().replaceAll("%player%", cubeletMachine.getPlayerOpening().getName()));
        }
        for (PermissionObject permissionObject : reward.getPermissions()) {
            Bukkit.getServer().dispatchCommand((CommandSender)this.main.getServer().getConsoleSender(), this.main.getDuplicationPermissionCommand().replaceAll("%player%", cubeletMachine.getPlayerOpening().getName()).replaceAll("%permission%", permissionObject.getPermission()));
        }
        for (ItemObject itemObject : reward.getItems()) {
            if (player == null) {
                cubeletMachine.getLocation().getWorld().dropItemNaturally(cubeletMachine.getLocation().clone().add(0.5, 1.0, 0.5), itemObject.getItemStack().clone());
                continue;
            }
            if (player.getInventory().firstEmpty() >= 0) {
                player.getInventory().addItem(new ItemStack[]{itemObject.getItemStack()});
                continue;
            }
            player.getLocation().getWorld().dropItemNaturally(player.getLocation(), itemObject.getItemStack().clone());
        }
        if (reward.getItems().size() > 0 && player != null) {
            Sounds.playSound(player, player.getLocation(), Sounds.MySound.ITEM_PICKUP, 0.5f, (float)ThreadLocalRandom.current().nextDouble(1.0, 3.0));
        }
        MessageUtils.sendLootMessage(cubeletMachine, cubeletType, reward);
        this.main.getDatabaseHandler().addLootHistory(uUID, lootHistory);
        if (player != null) {
            Profile profile = this.main.getPlayerDataHandler().getData(player);
            profile.getLootHistory().add(lootHistory);
            this.main.getMenuHandler().reloadAllMenus(player, LootHistoryMenu.class);
        }
    }

    public RepeatingTask duplicationTask(CubeletMachine cubeletMachine, Reward reward) {
        if (this.isDuplicated(cubeletMachine, reward)) {
            return this.main.getHologramImplementation().duplicationRewardHologram(cubeletMachine, reward);
        }
        return null;
    }

    public boolean isDuplicated(CubeletMachine cubeletMachine, Reward reward) {
        Profile profile = this.main.getPlayerDataHandler().getData(cubeletMachine.getPlayerOpening().getUuid());
        if (profile == null) {
            return true;
        }
        if (reward.isBypassDuplicationSystem()) {
            return false;
        }
        LootHistory lootHistory2 = profile.getLootHistory().stream().filter(lootHistory -> lootHistory.getRewardHistory().getUUID().toString().equalsIgnoreCase(reward.getRewardUUID().toString())).findFirst().orElse(null);
        return lootHistory2 != null;
    }

    public List<Rarity> getAvailableRarities(CubeletType cubeletType) {
        ArrayList<Rarity> arrayList = new ArrayList<Rarity>();
        for (String string : cubeletType.getRewards().keySet()) {
            arrayList.add(cubeletType.getRarities().get(string));
        }
        return arrayList;
    }

    public Rarity chooseOnWeight(List<Rarity> list) {
        double d = 0.0;
        for (Rarity rarity : list) {
            d += rarity.getChance();
        }
        double d2 = Math.random() * d;
        double d3 = 0.0;
        for (Rarity rarity : list) {
            if (!((d3 += rarity.getChance()) >= d2)) continue;
            return rarity;
        }
        throw new RuntimeException("Should never be shown.");
    }
}

