/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.handlers;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.objects.GUILayout;
import me.davidml16.acubelets.utils.ConfigUpdater;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class LayoutHandler {
    private HashMap<String, GUILayout> layouts;
    private Main main;

    public LayoutHandler(Main main) {
        this.main = main;
        this.layouts = new HashMap();
        new File(main.getDataFolder().toString() + "/gui_layouts").mkdirs();
        this.loadLayouts();
    }

    public GUILayout getLayout(String string) {
        return this.layouts.get(string);
    }

    public void createLayoutFile(String string) {
        File file = new File(this.main.getDataFolder() + "/gui_layouts/" + string + "_layout.yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        InputStreamReader inputStreamReader = new InputStreamReader(this.main.getResource("gui_layouts/" + string + "_layout.yml"));
        YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((Reader)inputStreamReader);
        for (String string2 : yamlConfiguration2.getKeys(true)) {
            if (yamlConfiguration2.get(string2) instanceof MemorySection) continue;
            linkedHashMap.put(string2, yamlConfiguration2.get(string2));
        }
        for (String string2 : linkedHashMap.keySet()) {
            if (yamlConfiguration.isSet(string2)) continue;
            yamlConfiguration.set(string2, linkedHashMap.get(string2));
        }
        for (String string2 : yamlConfiguration.getKeys(true)) {
            if (yamlConfiguration.get(string2) instanceof MemorySection || yamlConfiguration2.isSet(string2)) continue;
            yamlConfiguration.set(string2, null);
        }
        try {
            yamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            ConfigUpdater.update((Plugin)this.main, "gui_layouts/" + string + "_layout.yml", new File(this.main.getDataFolder() + "/gui_layouts/" + string + "_layout.yml"), Collections.emptyList());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void loadLayouts() {
        this.layouts.clear();
        this.createLayoutFile("crafting");
        this.loadLayout("crafting");
        this.createLayoutFile("craftingconfirmation");
        this.loadLayout("craftingconfirmation");
        this.createLayoutFile("opencubelet");
        this.loadLayout("opencubelet");
        this.createLayoutFile("preview");
        this.loadLayout("preview");
        this.createLayoutFile("animations");
        this.loadLayout("animations");
        this.createLayoutFile("gift");
        this.loadLayout("gift");
        this.createLayoutFile("giftamount");
        this.loadLayout("giftamount");
        this.createLayoutFile("giftplayer");
        this.loadLayout("giftplayer");
        this.createLayoutFile("loothistory");
        this.loadLayout("loothistory");
    }

    public void loadLayout(String string) {
        File file = new File(this.main.getDataFolder() + "/gui_layouts/" + string + "_layout.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        GUILayout gUILayout = new GUILayout();
        for (String string2 : yamlConfiguration.getKeys(true)) {
            if (yamlConfiguration.get(string2) instanceof MemorySection) continue;
            if (yamlConfiguration.get(string2) instanceof ArrayList) {
                gUILayout.getMessageList().put(string2, yamlConfiguration.getStringList(string2));
                continue;
            }
            gUILayout.getMessages().put(string2, yamlConfiguration.getString(string2));
        }
        this.layouts.put(string, gUILayout);
    }
}

