/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.handlers;

import com.cryptomorin.xseries.XItemStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MenuHandler {
    private Main main;
    private Map<Player, Menu> openedMenus;
    private ClickType rewardPreviewClickType;
    private boolean menuDecorationEnabled;
    private ItemStack menuDecorationItem;

    public MenuHandler(Main main) {
        this.main = main;
        this.openedMenus = new HashMap<Player, Menu>();
        this.rewardPreviewClickType = ClickType.SHIFT_LEFT;
        this.menuDecorationEnabled = main.getConfig().getBoolean("MenuDecoration.Enabled");
        this.menuDecorationItem = XItemStack.deserialize(Utils.getConfigurationSection((Configuration)main.getConfig(), "MenuDecoration.Item"));
    }

    public Map<Player, Menu> getOpenedMenus() {
        return this.openedMenus;
    }

    public void setOpenedMenus(Map<Player, Menu> map) {
        this.openedMenus = map;
    }

    public void addOpenedMenu(Player player, Menu menu) {
        this.openedMenus.put(player, menu);
    }

    public boolean hasOpenedMenu(Player player) {
        return this.openedMenus.containsKey(player);
    }

    public boolean hasOpenedMenu(Player player, Class<? extends Menu> clazz) {
        Menu menu = this.getOpenedMenu(player);
        if (menu == null) {
            return false;
        }
        return menu.getClass().equals(clazz);
    }

    public Menu getOpenedMenu(Player player) {
        return this.hasOpenedMenu(player) ? this.openedMenus.get(player) : null;
    }

    public ClickType getRewardPreviewClickType() {
        return this.rewardPreviewClickType;
    }

    public void setClickType(String string) {
        this.rewardPreviewClickType = Arrays.asList("LEFT", "RIGHT", "MIDDLE", "SHIFT_LEFT", "SHIFT_RIGHT").contains(string) ? ClickType.valueOf((String)string.toUpperCase()) : ClickType.SHIFT_LEFT;
    }

    public boolean isMenuDecorationEnabled() {
        return this.menuDecorationEnabled;
    }

    public void setMenuDecorationEnabled(boolean bl) {
        this.menuDecorationEnabled = bl;
    }

    public ItemStack getMenuDecorationItem() {
        return this.menuDecorationItem;
    }

    public void setMenuDecorationItem(ItemStack itemStack) {
        this.menuDecorationItem = itemStack;
    }

    public void handleMenuClick(Player player, InventoryClickEvent inventoryClickEvent) {
        Menu menu = this.getOpenedMenu(player);
        if (menu == null) {
            return;
        }
        menu.OnMenuClick(inventoryClickEvent);
    }

    public void handleMenuClose(Player player) {
        Menu menu = this.getOpenedMenu(player);
        if (menu == null) {
            return;
        }
        menu.OnMenuClosed();
        this.openedMenus.remove(player);
    }

    public void reloadAllMenus(Player player, Class<? extends Menu> clazz) {
        Menu menu = this.getOpenedMenu(player);
        if (menu == null) {
            return;
        }
        if (!menu.getClass().equals(clazz)) {
            return;
        }
        menu.reloadMyMenu();
    }

    public void reloadAllMenus(Class<? extends Menu> clazz) {
        for (Menu menu : this.openedMenus.values()) {
            if (!menu.getClass().equals(clazz)) continue;
            menu.reloadMyMenu();
        }
    }

    public void reloadAllMenus() {
        for (Menu menu : this.openedMenus.values()) {
            menu.reloadMyMenu();
        }
    }
}

