/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.admin.rewards;

import com.cryptomorin.xseries.XMaterial;
import java.util.List;
import java.util.Map;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.rewards.EditRewardConversation;
import me.davidml16.acubelets.conversation.rewards.RewardConversation;
import me.davidml16.acubelets.menus.admin.rewards.EditRewardCommandsMenu;
import me.davidml16.acubelets.menus.admin.rewards.EditRewardItemsMenu;
import me.davidml16.acubelets.menus.admin.rewards.EditRewardPermissionsMenu;
import me.davidml16.acubelets.menus.admin.type.TypeConfigMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class RewardsMenu
extends Menu {
    public RewardsMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        int n2;
        String string = (String)this.getAttribute(Menu.AttrType.CUSTOM_ID_ATTR);
        List<Reward> list = this.getMain().getCubeletTypesHandler().getTypeBydId(string).getAllRewards();
        if (n > 0 && list.size() < n * 21 + 1) {
            this.openPage(this.getPage() - 1);
            return;
        }
        Inventory inventory = this.createInventory(45, "%cubelet_type% | Rewards".replaceAll("%cubelet_type%", string));
        ItemStack itemStack = new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack();
        ItemStack itemStack2 = new ItemBuilder(XMaterial.SUNFLOWER.parseItem()).setName(Utils.translate("&aReward creator")).setLore("", Utils.translate("&eClick to create a new reward ")).toItemStack();
        ItemStack itemStack3 = new ItemBuilder(XMaterial.ARROW.parseItem()).setName(Utils.translate("&aBack to config")).toItemStack();
        this.fillBorders(itemStack);
        for (n2 = 10; n2 <= 16; ++n2) {
            inventory.setItem(n2, null);
        }
        for (n2 = 19; n2 <= 25; ++n2) {
            inventory.setItem(n2, null);
        }
        for (n2 = 28; n2 <= 34; ++n2) {
            inventory.setItem(n2, null);
        }
        if (n > 0) {
            inventory.setItem(18, new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).setName(Utils.translate("&aPrevious page")).toItemStack());
        } else {
            inventory.setItem(18, new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack());
        }
        if (list.size() > (n + 1) * 21) {
            inventory.setItem(26, new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).setName(Utils.translate("&aNext page")).toItemStack());
        } else {
            inventory.setItem(26, new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack());
        }
        if (list.size() > 21) {
            list = list.subList(n * 21, n * 21 + 21 > list.size() ? list.size() : n * 21 + 21);
        }
        if (list.size() > 0) {
            for (Reward reward : list) {
                inventory.addItem(new ItemStack[]{new ItemBuilder(reward.getIcon().clone()).setName(Utils.translate("&a" + reward.getId())).hideAttributes().setLore("", Utils.translate(" &7Name: &6" + reward.getName() + " "), Utils.translate(" &7Rarity: &6" + reward.getRarity().getId() + " "), Utils.translate(" &7Icon: &6" + reward.getIcon().getType().name() + " "), "", Utils.translate(" &7Commands: &6" + reward.getCommands().size() + " "), Utils.translate(" &7Permissions: &6" + reward.getPermissions().size() + " "), Utils.translate(" &7Items: &6" + reward.getItems().size() + " "), "", Utils.translate(" &7Bypass Duplication: &6" + reward.isBypassDuplicationSystem() + " "), "", Utils.translate("&eLeft-Click \u00bb &aEdit commands "), Utils.translate("&eMiddle-Click \u00bb &aEdit permissions "), Utils.translate("&eRight-Click \u00bb &aEdit items "), Utils.translate("&eShift-Left-Click \u00bb &aEdit reward properties "), Utils.translate("&eShift-Right-Click \u00bb &aDelete reward ")).toItemStack()});
            }
        } else {
            inventory.setItem(22, new ItemBuilder(XMaterial.RED_STAINED_GLASS_PANE.parseItem()).setName(Utils.translate("&cAny rewards created")).setLore("", Utils.translate(" &7You dont have any "), Utils.translate(" &7reward created. "), "").toItemStack());
        }
        inventory.setItem(39, itemStack2);
        inventory.setItem(41, itemStack3);
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        int n = inventoryClickEvent.getRawSlot();
        String string = (String)this.getAttribute(Menu.AttrType.CUSTOM_ID_ATTR);
        Player player = this.getOwner();
        CubeletType cubeletType = this.getMain().getCubeletTypesHandler().getTypeBydId(string);
        if (n == 18 && inventoryClickEvent.getCurrentItem().getType() == XMaterial.ENDER_PEARL.parseMaterial()) {
            this.previousPage();
            this.playSound(Menu.SoundType.CLICK);
        } else if (n == 26 && inventoryClickEvent.getCurrentItem().getType() == XMaterial.ENDER_PEARL.parseMaterial()) {
            this.nextPage();
            this.playSound(Menu.SoundType.CLICK);
        } else if (n == 39) {
            player.closeInventory();
            new RewardConversation(this.getMain()).getConversation(player, cubeletType).begin();
            this.playSound(Menu.SoundType.ANVIL_USE);
        } else if (n == 41) {
            TypeConfigMenu typeConfigMenu = new TypeConfigMenu(this.getMain(), player);
            typeConfigMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, cubeletType.getId());
            typeConfigMenu.open();
        } else if (n >= 10 && n <= 16 || n >= 19 && n <= 25 || n >= 28 && n <= 34) {
            if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            if (cubeletType.getAllRewards().size() == 0) {
                return;
            }
            String string2 = ChatColor.stripColor((String)inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName());
            Reward reward = cubeletType.getReward(string2);
            if (inventoryClickEvent.getClick() == ClickType.LEFT) {
                EditRewardCommandsMenu editRewardCommandsMenu = new EditRewardCommandsMenu(this.getMain(), player);
                editRewardCommandsMenu.setAttribute(Menu.AttrType.REWARD_ATTR, reward);
                editRewardCommandsMenu.open();
            } else if (inventoryClickEvent.getClick() == ClickType.MIDDLE) {
                EditRewardPermissionsMenu editRewardPermissionsMenu = new EditRewardPermissionsMenu(this.getMain(), player);
                editRewardPermissionsMenu.setAttribute(Menu.AttrType.REWARD_ATTR, reward);
                editRewardPermissionsMenu.open();
            } else if (inventoryClickEvent.getClick() == ClickType.RIGHT) {
                EditRewardItemsMenu editRewardItemsMenu = new EditRewardItemsMenu(this.getMain(), player);
                editRewardItemsMenu.setAttribute(Menu.AttrType.REWARD_ATTR, reward);
                editRewardItemsMenu.open();
            } else if (inventoryClickEvent.getClick() == ClickType.SHIFT_LEFT) {
                player.closeInventory();
                new EditRewardConversation(this.getMain()).getConversation(player, cubeletType, reward).begin();
                this.playSound(Menu.SoundType.ANVIL_USE);
            } else if (inventoryClickEvent.getClick() == ClickType.SHIFT_RIGHT) {
                Map<String, List<Reward>> map = cubeletType.getRewards();
                List<Reward> list = cubeletType.getRewards().get(reward.getRarity().getId());
                list.remove(reward);
                map.put(reward.getRarity().getId(), list);
                cubeletType.setRewards(map);
                player.sendMessage(Utils.translate(this.getMain().getLanguageHandler().getPrefix() + " &aYou removed reward &e" + string2 + " &afrom rewards of cubelet type &e" + cubeletType.getId()));
                this.reloadMenu();
                this.playSound(Menu.SoundType.CLICK);
            }
        }
    }

    @Override
    public void OnMenuClosed() {
        String string = (String)this.getAttribute(Menu.AttrType.CUSTOM_ID_ATTR);
        this.getMain().getCubeletTypesHandler().getTypeBydId(string).saveType();
    }
}

