/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.player.crafting;

import com.cryptomorin.xseries.XMaterial;
import java.sql.SQLException;
import java.util.ArrayList;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.enums.CraftType;
import me.davidml16.acubelets.menus.player.CubeletsMenu;
import me.davidml16.acubelets.menus.player.crafting.CraftingMenu;
import me.davidml16.acubelets.objects.CraftIngredient;
import me.davidml16.acubelets.objects.CraftParent;
import me.davidml16.acubelets.objects.GUILayout;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CraftingConfirmationMenu
extends Menu {
    public CraftingConfirmationMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        String string3;
        Player player = this.getOwner();
        String string2 = (String)this.getAttribute(Menu.AttrType.CUSTOM_ID_ATTR);
        player.updateInventory();
        GUILayout gUILayout = this.getMain().getLayoutHandler().getLayout("craftingconfirmation");
        Inventory inventory = this.createInventory(InventoryType.HOPPER, gUILayout.getMessage("Title"));
        CraftParent craftParent = this.getMain().getCubeletCraftingHandler().getCraftById(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : gUILayout.getMessageList("Items.Craft.Lore")) {
            if (string3.contains("%ingredients%")) {
                for (CraftIngredient craftIngredient : craftParent.getIngrediens()) {
                    if (craftIngredient.getCraftType() == CraftType.CUBELET) {
                        arrayList.add(Utils.translate(gUILayout.getMessage("Ingredients.Ingredient.Cubelet").replaceAll("%name%", Utils.removeColors(this.getMain().getCubeletTypesHandler().getTypeBydId(craftIngredient.getName()).getName())).replaceAll("%amount%", "" + craftIngredient.getAmount())));
                        continue;
                    }
                    if (craftIngredient.getCraftType() == CraftType.MONEY) {
                        arrayList.add(Utils.translate(gUILayout.getMessage("Ingredients.Ingredient.Money").replaceAll("%amount%", "" + craftIngredient.getAmount())));
                        continue;
                    }
                    if (craftIngredient.getCraftType() != CraftType.POINTS) continue;
                    arrayList.add(Utils.translate(gUILayout.getMessage("Ingredients.Ingredient.Points").replaceAll("%amount%", "" + craftIngredient.getAmount())));
                }
                continue;
            }
            arrayList.add(Utils.translate(string3));
        }
        ItemStack itemStack = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Craft.Material")).get().parseItem()).setName(Utils.translate(gUILayout.getMessage("Items.Craft.Name"))).setLore(arrayList).toItemStack();
        string3 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Cancel.Material")).get().parseItem()).setName(Utils.translate(gUILayout.getMessage("Items.Cancel.Name"))).setLore(gUILayout.getMessageList("Items.Cancel.Lore")).toItemStack();
        inventory.setItem(1, itemStack);
        inventory.setItem(3, (ItemStack)string3);
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        Player player = this.getOwner();
        int n = inventoryClickEvent.getRawSlot();
        if (n == 1) {
            String string = (String)this.getAttribute(Menu.AttrType.CUSTOM_ID_ATTR);
            CraftParent craftParent = this.getMain().getCubeletCraftingHandler().getCraftById(string);
            if (!this.getMain().getCubeletCraftingHandler().haveIngredients(player, craftParent)) {
                player.sendMessage(this.getMain().getLayoutHandler().getLayout("crafting").getMessage("NoAfford"));
                return;
            }
            this.getMain().getCubeletCraftingHandler().removeIngredients(player, craftParent);
            try {
                this.getMain().getTransactionHandler().giveCubelet(player.getUniqueId(), craftParent.getCubeletType(), 1);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            new CubeletsMenu(this.getMain(), player).open();
            this.playSound(Menu.SoundType.ANVIL_USE);
        } else if (n == 3) {
            new CraftingMenu(this.getMain(), player).open();
        }
    }

    @Override
    public void OnMenuClosed() {
    }
}

