/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.player.gifts;

import com.cryptomorin.xseries.XMaterial;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.ArrayList;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.menus.player.CubeletsMenu;
import me.davidml16.acubelets.menus.player.gifts.GiftCubeletMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.GUILayout;
import me.davidml16.acubelets.objects.GiftGuiSession;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.Profile;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GiftMenu
extends Menu {
    public GiftMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        Object object;
        int n2;
        Player player = this.getOwner();
        GiftGuiSession giftGuiSession = (GiftGuiSession)this.getAttribute(Menu.AttrType.GIFT_GUISESSION_ATTR);
        List<CubeletType> list = this.getCubeletTypesAvailable(player);
        if (n > 0 && list.size() < n * 14 + 1) {
            this.openPage(this.getPage() - 1);
            return;
        }
        GUILayout gUILayout = this.getMain().getLayoutHandler().getLayout("gift");
        Profile profile = this.getMain().getPlayerDataHandler().getData(player);
        Inventory inventory = this.createInventory(45, gUILayout.getMessage("Title"));
        ItemStack itemStack = new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack();
        if (n > 0) {
            n2 = gUILayout.getBoolean("Items.PreviousPage.ShowPageNumber") ? n : 1;
            ItemStack itemStack2 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.PreviousPage.Material")).get().parseMaterial(), n2).setName(gUILayout.getMessage("Items.PreviousPage.Name")).toItemStack();
            itemStack2 = NBTEditor.set(itemStack2, "previous", "action");
            inventory.setItem(35 + gUILayout.getSlot("PreviousPage"), itemStack2);
        }
        if (list.size() > (n + 1) * 14) {
            n2 = gUILayout.getBoolean("Items.NextPage.ShowPageNumber") ? n + 2 : 1;
            ItemStack itemStack4 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.NextPage.Material")).get().parseMaterial(), n2).setName(gUILayout.getMessage("Items.NextPage.Name")).toItemStack();
            itemStack4 = NBTEditor.set(itemStack4, "next", "action");
            inventory.setItem(35 + gUILayout.getSlot("NextPage"), itemStack4);
        }
        if (giftGuiSession.isOpenedByCommand()) {
            object = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Close.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Close.Name")).setLore(gUILayout.getMessageList("Items.Close.Lore")).toItemStack();
            object = NBTEditor.set(object, "close", "action");
            inventory.setItem(35 + gUILayout.getSlot("Close"), (ItemStack)object);
        } else {
            object = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Back.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Back.Name")).setLore(gUILayout.getMessageList("Items.Back.Lore")).toItemStack();
            object = NBTEditor.set(object, "back", "action");
            inventory.setItem(35 + gUILayout.getSlot("Back"), (ItemStack)object);
        }
        this.fillTopSide(itemStack, 4);
        if (list.size() > 14) {
            list = list.subList(n * 14, n * 14 + 14 > list.size() ? list.size() : n * 14 + 14);
        }
        if (list.size() > 0) {
            for (CubeletType cubeletType : list) {
                long l = profile.getCubelets().stream().filter(cubelet -> cubelet.getType().equalsIgnoreCase(cubeletType.getId())).count();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : gUILayout.getMessageList("Items.Cubelet.Lore")) {
                    arrayList.add(Utils.translate(string.replaceAll("%cubelets_available%", String.valueOf(l))));
                }
                ItemStack itemStack5 = new ItemBuilder(cubeletType.getIcon().clone()).setName(Utils.translate(gUILayout.getMessage("Items.Cubelet.Name").replace("%cubelet_name%", cubeletType.getName()))).setLore(arrayList).toItemStack();
                itemStack5 = NBTEditor.set(itemStack5, "send", "action");
                itemStack5 = NBTEditor.set(itemStack5, cubeletType.getId(), "typeID");
                inventory.addItem(new ItemStack[]{itemStack5});
            }
        }
        this.fillTopSide(null, 4);
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        Player player = this.getOwner();
        GiftGuiSession giftGuiSession = (GiftGuiSession)this.getAttribute(Menu.AttrType.GIFT_GUISESSION_ATTR);
        String string = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "action");
        if (inventoryClickEvent.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        if (string == null) {
            return;
        }
        switch (string) {
            case "send": {
                String string2 = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "typeID");
                CubeletType cubeletType = this.getMain().getCubeletTypesHandler().getTypeBydId(string2);
                GiftCubeletMenu giftCubeletMenu = new GiftCubeletMenu(this.getMain(), player);
                giftGuiSession.setCubeletType(cubeletType);
                giftCubeletMenu.setAttribute(Menu.AttrType.GIFT_GUISESSION_ATTR, giftGuiSession);
                giftCubeletMenu.open();
                break;
            }
            case "previous": {
                this.previousPage();
                break;
            }
            case "next": {
                this.nextPage();
                break;
            }
            case "close": {
                player.closeInventory();
                break;
            }
            case "back": {
                new CubeletsMenu(this.getMain(), player).open();
            }
        }
    }

    @Override
    public void OnMenuClosed() {
    }

    private List<CubeletType> getCubeletTypesAvailable(Player player) {
        Profile profile = this.getMain().getPlayerDataHandler().getData(player);
        ArrayList<CubeletType> arrayList = new ArrayList<CubeletType>();
        for (CubeletType cubeletType : this.getMain().getCubeletTypesHandler().getTypes().values()) {
            long l = profile.getCubelets().stream().filter(cubelet -> cubelet.getType().equalsIgnoreCase(cubeletType.getId())).count();
            if (l <= 0L) continue;
            arrayList.add(cubeletType);
        }
        return arrayList;
    }
}

