/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.player.rewards;

import com.cryptomorin.xseries.XMaterial;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.menus.player.CubeletsMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.GUILayout;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class RewardsPreviewMenu
extends Menu {
    public RewardsPreviewMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        ItemStack itemStack;
        int n2;
        String string = (String)this.getAttribute(Menu.AttrType.CUSTOM_ID_ATTR);
        Boolean bl = (Boolean)this.getAttribute(Menu.AttrType.OPENED_EXTERNALLY_ATTR);
        Player player = this.getOwner();
        CubeletType cubeletType = this.getMain().getCubeletTypesHandler().getTypeBydId(string);
        List<Reward> list = cubeletType.getAllRewards();
        GUILayout gUILayout = this.getMain().getLayoutHandler().getLayout("preview");
        int n3 = this.getPageSize(gUILayout);
        if (n > 0 && list.size() < n * n3 + 1) {
            this.openPage(this.getPage() - 1);
            return;
        }
        if (list.size() > n3) {
            list = list.subList(n * n3, Math.min(n * n3 + n3, list.size()));
        }
        int n4 = this.getNeededSize(gUILayout, list.size());
        Inventory inventory = this.createInventory(n4, gUILayout.getMessage("Title").replaceAll("%cubelet_type%", Utils.removeColors(cubeletType.getName())));
        if (n > 0) {
            n2 = gUILayout.getBoolean("Items.PreviousPage.ShowPageNumber") ? n : 1;
            ItemStack itemStack2 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.PreviousPage.Material")).get().parseMaterial(), n2).setName(gUILayout.getMessage("Items.PreviousPage.Name")).toItemStack();
            itemStack2 = NBTEditor.set(itemStack2, "previous", "action");
            if (gUILayout.getSlot("PreviousPage") >= 0) {
                inventory.setItem(n4 - 10 + gUILayout.getSlot("PreviousPage"), itemStack2);
            }
        }
        if (cubeletType.getAllRewards().size() > (n + 1) * n3) {
            n2 = gUILayout.getBoolean("Items.NextPage.ShowPageNumber") ? n + 2 : 1;
            ItemStack itemStack4 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.NextPage.Material")).get().parseMaterial(), n2).setName(gUILayout.getMessage("Items.NextPage.Name")).toItemStack();
            itemStack4 = NBTEditor.set(itemStack4, "next", "action");
            if (gUILayout.getSlot("NextPage") >= 0) {
                inventory.setItem(n4 - 10 + gUILayout.getSlot("NextPage"), itemStack4);
            }
        }
        if (!bl.booleanValue()) {
            itemStack = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Back.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Back.Name")).setLore(gUILayout.getMessageList("Items.Back.Lore")).toItemStack();
            itemStack = NBTEditor.set(itemStack, "back", "action");
            inventory.setItem(n4 - 10 + gUILayout.getSlot("Back"), itemStack);
        } else {
            itemStack = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Close.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Close.Name")).setLore(gUILayout.getMessageList("Items.Close.Lore")).toItemStack();
            itemStack = NBTEditor.set(itemStack, "close", "action");
            inventory.setItem(n4 - 10 + gUILayout.getSlot("Close"), itemStack);
        }
        for (int i = 0; i <= n4 - 10; ++i) {
            inventory.setItem(i, null);
        }
        if (list.size() > 0) {
            for (Reward reward : list) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (reward.getIcon().getItemMeta().hasLore()) {
                    arrayList.addAll(reward.getIcon().getItemMeta().getLore());
                    arrayList.add("");
                }
                for (String string2 : gUILayout.getMessageList("Items.Reward.Lore")) {
                    string2 = string2.replaceAll("%reward_rarity%", reward.getRarity().getName());
                    string2 = string2.replaceAll("%reward_chance%", Double.toString(reward.getRarity().getChance()));
                    string2 = string2.replaceAll("%reward_name%", Matcher.quoteReplacement(reward.getName()));
                    string2 = string2.replaceAll("%reward_id%", reward.getId());
                    arrayList.add(Utils.translate(string2));
                }
                inventory.addItem(new ItemStack[]{new ItemBuilder(reward.getIcon().clone()).setName(Utils.translate(gUILayout.getMessage("Items.Reward.Name").replaceAll("%reward_name%", Matcher.quoteReplacement(reward.getName())))).setLore(arrayList).hideAttributes().toItemStack()});
            }
        } else {
            player.closeInventory();
        }
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        int n;
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        Player player = this.getOwner();
        int n2 = inventoryClickEvent.getRawSlot();
        if (n2 >= (n = player.getOpenInventory().getTopInventory().getSize()) - 9 && n2 <= n) {
            String string = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "action");
            if (inventoryClickEvent.getClick() == ClickType.DOUBLE_CLICK) {
                return;
            }
            if (string == null) {
                return;
            }
            switch (string) {
                case "previous": {
                    this.previousPage();
                    break;
                }
                case "next": {
                    this.nextPage();
                    break;
                }
                case "close": {
                    player.closeInventory();
                    break;
                }
                case "back": {
                    new CubeletsMenu(this.getMain(), player).open();
                }
            }
        }
        player.updateInventory();
    }

    @Override
    public void OnMenuClosed() {
    }

    private int getNeededSize(GUILayout gUILayout, int n) {
        int n2 = 0;
        int n3 = gUILayout.getInteger("Size.Max-Cubelets-Rows");
        if (n3 < 1) {
            n3 = 1;
        } else if (n3 > 5) {
            n3 = 5;
        }
        n2 = gUILayout.getBoolean("Size.Dynamic") ? (n3 == 1 ? 1 : (n3 == 2 ? (n <= 9 ? 1 : 2) : (n3 == 3 ? (n >= 0 && n <= 9 ? 1 : (n >= 9 && n <= 18 ? 2 : 3)) : (n3 == 4 ? (n >= 0 && n <= 9 ? 1 : (n >= 9 && n <= 18 ? 2 : (n >= 18 && n <= 27 ? 3 : 4))) : (n >= 0 && n <= 9 ? 1 : (n >= 9 && n <= 18 ? 2 : (n >= 18 && n <= 27 ? 3 : (n >= 27 && n <= 36 ? 4 : 5)))))))) : n3;
        return (n2 + 1) * 9;
    }

    private int getPageSize(GUILayout gUILayout) {
        int n = gUILayout.getInteger("Size.Max-Cubelets-Rows");
        if (n < 1) {
            n = 1;
        } else if (n > 5) {
            n = 5;
        }
        return n * 9;
    }
}

