/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.objects;

import me.davidml16.acubelets.effects.MachineEffectModel;
import me.davidml16.acubelets.effects.SimpleParticle;
import me.davidml16.acubelets.enums.CubeletBoxState;
import me.davidml16.acubelets.enums.Rotation;
import me.davidml16.acubelets.objects.CubeletOpener;
import me.davidml16.acubelets.objects.rewards.Reward;
import org.bukkit.Location;
import org.bukkit.Particle;

public class CubeletMachine {
    private Location location;
    private double blockHeight;
    private double permanentBlockHeight;
    private Rotation rotation;
    private CubeletOpener playerOpening;
    private CubeletBoxState state;
    private MachineEffectModel blockEffectModel;
    private SimpleParticle blockEffectParticle;
    private Reward lastReward;
    private int lastDuplicationPoints;

    public CubeletMachine(Location location, double d, double d2, Rotation rotation) {
        this.location = location;
        this.state = CubeletBoxState.EMPTY;
        this.playerOpening = null;
        this.lastReward = null;
        this.lastDuplicationPoints = 0;
        this.blockHeight = d;
        this.permanentBlockHeight = d2;
        this.rotation = rotation;
        this.blockEffectModel = MachineEffectModel.NONE;
        this.blockEffectParticle = SimpleParticle.of(Particle.FLAME);
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public double getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(double d) {
        this.blockHeight = d;
    }

    public double getPermanentBlockHeight() {
        return this.permanentBlockHeight;
    }

    public void setPermanentBlockHeight(double d) {
        this.permanentBlockHeight = d;
    }

    public CubeletBoxState getState() {
        return this.state;
    }

    public void setState(CubeletBoxState cubeletBoxState) {
        this.state = cubeletBoxState;
    }

    public CubeletOpener getPlayerOpening() {
        return this.playerOpening;
    }

    public void setPlayerOpening(CubeletOpener cubeletOpener) {
        this.playerOpening = cubeletOpener;
    }

    public Reward getLastReward() {
        return this.lastReward;
    }

    public void setLastReward(Reward reward) {
        this.lastReward = reward;
    }

    public int getLastDuplicationPoints() {
        return this.lastDuplicationPoints;
    }

    public void setLastDuplicationPoints(int n) {
        this.lastDuplicationPoints = n;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public MachineEffectModel getBlockEffectModel() {
        return this.blockEffectModel;
    }

    public void setBlockEffectModel(MachineEffectModel machineEffectModel) {
        this.blockEffectModel = machineEffectModel;
    }

    public SimpleParticle getBlockEffectParticle() {
        return this.blockEffectParticle;
    }

    public void setBlockEffectParticle(SimpleParticle simpleParticle) {
        this.blockEffectParticle = simpleParticle;
    }

    public boolean isWaiting() {
        return this.state == CubeletBoxState.EMPTY;
    }

    public String toString() {
        return "CubeletBox{location=" + this.location + ", state=" + this.state.toString() + '}';
    }
}

