/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.objects.rewards;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Rarity;
import me.davidml16.acubelets.objects.rewards.CommandObject;
import me.davidml16.acubelets.objects.rewards.ItemObject;
import me.davidml16.acubelets.objects.rewards.PermissionObject;
import org.bukkit.inventory.ItemStack;

public class Reward {
    private String id;
    private String name;
    private Rarity rarity;
    private ItemStack icon;
    private CubeletType parentCubelet;
    private boolean bypassDuplicationSystem;
    private List<CommandObject> commands;
    private List<PermissionObject> permissions;
    private List<ItemObject> items;
    private UUID rewardUUID;

    public Reward(String string, String string2, Rarity rarity, ItemStack itemStack, CubeletType cubeletType) {
        this.id = string;
        this.name = string2;
        this.rarity = rarity;
        this.icon = itemStack;
        this.parentCubelet = cubeletType;
        this.rewardUUID = UUID.randomUUID();
        this.bypassDuplicationSystem = true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public void setRarity(Rarity rarity) {
        this.rarity = rarity;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public void setIcon(ItemStack itemStack) {
        this.icon = itemStack;
    }

    public CubeletType getParentCubelet() {
        return this.parentCubelet;
    }

    public void setParentCubelet(CubeletType cubeletType) {
        this.parentCubelet = cubeletType;
    }

    public UUID getRewardUUID() {
        return this.rewardUUID;
    }

    public void setRewardUUID(UUID uUID) {
        this.rewardUUID = uUID;
    }

    public boolean isBypassDuplicationSystem() {
        return this.bypassDuplicationSystem;
    }

    public void setBypassDuplicationSystem(boolean bl) {
        this.bypassDuplicationSystem = bl;
    }

    public List<CommandObject> getCommands() {
        if (this.commands == null) {
            this.commands = new ArrayList<CommandObject>();
        }
        return this.commands;
    }

    public void setCommands(List<CommandObject> list) {
        this.commands = list;
    }

    public CommandObject getCommand(String string) {
        return this.commands.stream().filter(commandObject -> commandObject.getId().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public void recreateCommands() {
        int n = 0;
        for (CommandObject commandObject : this.getCommands()) {
            commandObject.setId("command-" + n);
            ++n;
        }
    }

    public List<PermissionObject> getPermissions() {
        if (this.permissions == null) {
            this.permissions = new ArrayList<PermissionObject>();
        }
        return this.permissions;
    }

    public void setPermissions(List<PermissionObject> list) {
        this.permissions = list;
    }

    public PermissionObject getPermission(String string) {
        return this.permissions.stream().filter(permissionObject -> permissionObject.getId().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public void recreatePermissions() {
        int n = 0;
        for (PermissionObject permissionObject : this.getPermissions()) {
            permissionObject.setId("permission-" + n);
            ++n;
        }
    }

    public List<ItemObject> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<ItemObject>();
        }
        return this.items;
    }

    public void setItems(List<ItemObject> list) {
        this.items = list;
    }

    public ItemObject getItem(String string) {
        return this.items.stream().filter(itemObject -> itemObject.getId().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public void recreateItems() {
        int n = 0;
        for (ItemObject itemObject : this.getItems()) {
            itemObject.setId("item-" + n);
            ++n;
        }
    }

    public String toString() {
        return "Reward{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", rarity=" + this.rarity + ", icon=" + this.icon + '}';
    }
}

