/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.davidml16.acubelets.Main;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FireworkUtil {
    private Main main;

    public FireworkUtil(Main main) {
        this.main = main;
    }

    public void spawn(Location location, FireworkEffect.Type type, Color ... colorArray) {
        final Firework firework = (Firework)location.getWorld().spawn(location, Firework.class);
        firework.setMetadata("nodamage", (MetadataValue)new FixedMetadataValue((Plugin)this.main, (Object)true));
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        fireworkMeta.addEffects(new FireworkEffect[]{FireworkEffect.builder().withColor(colorArray).with(type).build()});
        fireworkMeta.setPower(1);
        firework.setFireworkMeta(fireworkMeta);
        new BukkitRunnable(){

            public void run() {
                firework.detonate();
            }
        }.runTaskLater((Plugin)this.main, 1L);
    }

    public List<Color> getRandomColors() {
        int n = new Random().nextInt(4) + 1;
        ArrayList<Color> arrayList = new ArrayList<Color>();
        switch (n) {
            case 1: {
                arrayList.add(Color.BLUE);
                arrayList.add(Color.AQUA);
                break;
            }
            case 2: {
                arrayList.add(Color.RED);
                arrayList.add(Color.ORANGE);
                break;
            }
            case 3: {
                arrayList.add(Color.GREEN);
                arrayList.add(Color.LIME);
                break;
            }
            case 4: {
                arrayList.add(Color.PURPLE);
                arrayList.add(Color.FUCHSIA);
            }
        }
        return arrayList;
    }
}

