/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class LocationUtils {
    public static List<Location> getCircle(Location location, double d, int n) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        double d2 = Math.PI * 2 / (double)n;
        for (int i = 0; i < n; ++i) {
            double d3 = (double)i * d2;
            double d4 = location.getX() + Math.cos(d3) * d;
            double d5 = location.getZ() + Math.sin(d3) * d;
            arrayList.add(new Location(location.getWorld(), d4, location.getY(), d5));
        }
        return arrayList;
    }

    @NotNull
    public static String getWorldName(@NotNull Location location) {
        World world = location.getWorld();
        return world == null ? "null" : world.getName();
    }

    @NotNull
    public static Location getFirstGroundBlock(@NotNull Location location) {
        float f = location.getYaw();
        float f2 = location.getPitch();
        Block block = location.getBlock();
        while ((block.isEmpty() || !block.getType().isSolid()) && block.getY() > 0) {
            block = block.getRelative(BlockFace.DOWN);
        }
        location = block.getRelative(BlockFace.UP).getLocation();
        location.setYaw(f);
        location.setPitch(f2);
        return location;
    }

    @NotNull
    public static Location getCenter(@NotNull Location location) {
        return LocationUtils.getCenter(location, true);
    }

    @NotNull
    public static Location getCenter(@NotNull Location location, boolean bl) {
        float f = location.getYaw();
        float f2 = location.getPitch();
        double d = LocationUtils.getRelativeCoord(location.getBlockX());
        double d2 = bl ? LocationUtils.getRelativeCoord(location.getBlockY()) : (double)location.getBlockY();
        double d3 = LocationUtils.getRelativeCoord(location.getBlockZ());
        location = new Location(location.getWorld(), d, d2, d3);
        location.setYaw(f);
        location.setPitch(f2);
        return location;
    }

    private static double getRelativeCoord(double d) {
        return d < 0.0 ? d + 0.5 : d + 0.5;
    }

    @NotNull
    public static Location getPointOnCircle(@NotNull Location location, double d, double d2, double d3) {
        return LocationUtils.getPointOnCircle(location, true, d, d2, d3);
    }

    @NotNull
    public static Location getPointOnCircle(@NotNull Location location, boolean bl, double d, double d2, double d3) {
        return (bl ? location.clone() : location).add(Math.cos(d) * d2, d3, Math.sin(d) * d2);
    }

    public static BlockFace getDirection(@NotNull Entity entity) {
        float f = Math.round(entity.getLocation().getYaw() / 90.0f);
        if (f == -4.0f || f == 0.0f || f == 4.0f) {
            return BlockFace.SOUTH;
        }
        if (f == -1.0f || f == 3.0f) {
            return BlockFace.EAST;
        }
        if (f == -2.0f || f == 2.0f) {
            return BlockFace.NORTH;
        }
        if (f == -3.0f || f == 1.0f) {
            return BlockFace.WEST;
        }
        return null;
    }

    @NotNull
    public static Vector getDirectionTo(@NotNull Location location, @NotNull Location location2) {
        Location location3 = location.clone();
        Vector vector = location2.clone().toVector();
        location3.setDirection(vector.subtract(location3.toVector()));
        return location3.getDirection();
    }
}

