/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils;

import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class Pair<F, S> {
    private final F first;
    private final S second;

    public Pair(@NotNull F f, @NotNull S s) {
        this.first = f;
        this.second = s;
    }

    @NotNull
    public F getFirst() {
        return this.first;
    }

    @NotNull
    public S getSecond() {
        return this.second;
    }

    @NotNull
    public Pair<S, F> swap() {
        return Pair.of(this.second, this.first);
    }

    public String toString() {
        return "Pair{first=" + this.first + ", second=" + this.second + '}';
    }

    public boolean equals(Object object) {
        if (this.getClass().getName().equalsIgnoreCase(object.getClass().getName())) {
            return Objects.equals(this.first, ((Pair)object).first) && Objects.equals(this.second, ((Pair)object).second);
        }
        return false;
    }

    @NotNull
    public <F2> Pair<F2, S> mapFirst(@NotNull Function<? super F, ? extends F2> function) {
        return Pair.of(function.apply(this.first), this.second);
    }

    @NotNull
    public <S2> Pair<F, S2> mapSecond(@NotNull Function<? super S, ? extends S2> function) {
        return Pair.of(this.first, function.apply(this.second));
    }

    @NotNull
    public static <F, S> Pair<F, S> of(@NotNull F f, @NotNull S s) {
        return new Pair<F, S>(f, s);
    }
}

