/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.davidml16.acubelets.utils.Colorizer;
import me.davidml16.acubelets.utils.Pair;
import me.davidml16.acubelets.utils.random.Rnd;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;

public class StringUtils {
    @NotNull
    public static String oneSpace(@NotNull String string) {
        return string.trim().replaceAll("\\s+", " ");
    }

    @NotNull
    public static String noSpace(@NotNull String string) {
        return string.trim().replaceAll("\\s+", "");
    }

    @NotNull
    public static List<String> replace(@NotNull List<String> list, @NotNull String string, boolean bl, String ... stringArray) {
        return StringUtils.replace(list, string, bl, Arrays.asList(stringArray));
    }

    @NotNull
    public static List<String> replace(@NotNull List<String> list, @NotNull String string, boolean bl, List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            if (string2.contains(string)) {
                if (!bl) {
                    arrayList.addAll(list2);
                    continue;
                }
                list2.forEach(string3 -> arrayList.add(string2.replace(string, (CharSequence)string3)));
                continue;
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    @NotNull
    public static String replaceEach(@NotNull String string, @NotNull List<Pair<String, Supplier<String>>> list) {
        int n;
        int n2;
        int n3;
        if (string.isEmpty() || list.isEmpty()) {
            return string;
        }
        int n4 = list.size();
        boolean[] blArray = new boolean[n4];
        int n5 = -1;
        int n6 = -1;
        for (n3 = 0; n3 < n4; ++n3) {
            if (blArray[n3]) continue;
            n2 = string.indexOf(list.get(n3).getFirst());
            if (n2 == -1) {
                blArray[n3] = true;
                continue;
            }
            if (n5 != -1 && n2 >= n5) continue;
            n5 = n2;
            n6 = n3;
        }
        if (n5 == -1) {
            return string;
        }
        n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (n5 != -1) {
            for (n = n3; n < n5; ++n) {
                stringBuilder.append(string.charAt(n));
            }
            stringBuilder.append(list.get(n6).getSecond().get());
            n3 = n5 + list.get(n6).getFirst().length();
            n5 = -1;
            n6 = -1;
            for (n = 0; n < n4; ++n) {
                if (blArray[n]) continue;
                n2 = string.indexOf(list.get(n).getFirst(), n3);
                if (n2 == -1) {
                    blArray[n] = true;
                    continue;
                }
                if (n5 != -1 && n2 >= n5) continue;
                n5 = n2;
                n6 = n;
            }
        }
        n = string.length();
        for (int i = n3; i < n; ++i) {
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static double getDouble(@NotNull String string, double d) {
        return StringUtils.getDouble(string, d, false);
    }

    public static double getDouble(@NotNull String string, double d, boolean bl) {
        try {
            double d2 = Double.parseDouble(string);
            return d2 < 0.0 && !bl ? d : d2;
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public static float getFloat(@NotNull String string, float f) {
        return StringUtils.getFloat(string, f, false);
    }

    public static float getFloat(@NotNull String string, float f, boolean bl) {
        try {
            float f2 = Float.parseFloat(string);
            return f2 < 0.0f && !bl ? f : f2;
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public static int getInteger(@NotNull String string, int n) {
        return StringUtils.getInteger(string, n, false);
    }

    public static int getInteger(@NotNull String string, int n, boolean bl) {
        return (int)StringUtils.getDouble(string, n, bl);
    }

    public static int[] getIntArray(@NotNull String string) {
        String[] stringArray = StringUtils.noSpace(string).split(",");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[i] = 0;
            }
        }
        return nArray;
    }

    @NotNull
    public static <T extends Enum<T>> Optional<T> getEnum(@NotNull String string, @NotNull Class<T> clazz) {
        try {
            return Optional.of(Enum.valueOf(clazz, string.toUpperCase()));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    @NotNull
    public static Color parseColor(@NotNull String string) {
        int n;
        int n2;
        String[] stringArray = string.split(",");
        int n3 = StringUtils.getInteger(stringArray[0], 0);
        if (n3 < 0) {
            n3 = Rnd.get(255);
        }
        int n4 = n2 = stringArray.length >= 2 ? StringUtils.getInteger(stringArray[1], 0) : 0;
        if (n2 < 0) {
            n2 = Rnd.get(255);
        }
        int n5 = n = stringArray.length >= 3 ? StringUtils.getInteger(stringArray[2], 0) : 0;
        if (n < 0) {
            n = Rnd.get(255);
        }
        return Color.fromRGB((int)n3, (int)n2, (int)n);
    }

    @NotNull
    public static String lowerCaseUnderscore(@NotNull String string) {
        return Colorizer.restrip(string).toLowerCase().replace(" ", "_");
    }

    @NotNull
    public static String capitalizeUnderscored(@NotNull String string) {
        return StringUtils.capitalizeFully(string.replace("_", " "));
    }

    @NotNull
    public static String capitalizeFully(@NotNull String string) {
        if (string.length() != 0) {
            string = string.toLowerCase();
            return StringUtils.capitalize(string);
        }
        return string;
    }

    @NotNull
    public static String capitalize(@NotNull String string) {
        if (string.length() != 0) {
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n);
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (Character.isWhitespace(c)) {
                    stringBuilder.append(c);
                    bl = true;
                    continue;
                }
                if (bl) {
                    stringBuilder.append(Character.toTitleCase(c));
                    bl = false;
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    @NotNull
    public static String capitalizeFirstLetter(@NotNull String string) {
        if (string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    @NotNull
    public static List<String> stripEmpty(@NotNull List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (string.isEmpty()) {
                String string2;
                String string3 = string2 = arrayList.isEmpty() ? null : (String)arrayList.get(arrayList.size() - 1);
                if (string2 == null || string2.isEmpty() || i == list.size() - 1) continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getByPartialMatches(@NotNull List<String> list, @NotNull String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toLowerCase().toCharArray()) {
            stringBuilder.append(Pattern.quote(String.valueOf(c))).append("(?:.*)");
        }
        Object object = Pattern.compile(stringBuilder.toString());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            if (!((Pattern)object).matcher(string2.toLowerCase()).find()) continue;
            arrayList.add(string2);
        }
        ArrayList arrayList2 = new ArrayList(arrayList);
        Collections.sort(arrayList2);
        return arrayList2;
    }

    @NotNull
    public static String extractCommandName(@NotNull String string) {
        String string2 = Colorizer.strip(string).split(" ")[0].substring(1);
        String[] stringArray = string2.split(":");
        if (stringArray.length == 2) {
            string2 = stringArray[1];
        }
        return string2;
    }

    @Deprecated
    public static boolean isCustomBoolean(@NotNull String string) {
        String[] stringArray = new String[]{"0", "1", "on", "off", "true", "false", "yes", "no"};
        return Stream.of(stringArray).collect(Collectors.toSet()).contains(string.toLowerCase());
    }

    @Deprecated
    public static boolean parseCustomBoolean(@NotNull String string) {
        if (string.equalsIgnoreCase("0") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("no")) {
            return false;
        }
        if (string.equalsIgnoreCase("1") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("yes")) {
            return true;
        }
        return Boolean.parseBoolean(string);
    }
}

