/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils.TimeAPI;

import java.util.concurrent.TimeUnit;
import me.davidml16.acubelets.utils.TimeAPI.TimeScanner;

public class TimeAPI {
    private static final long DAYS_IN_WEEK = 7L;
    private static final long DAYS_IN_MONTH = 30L;
    private static final long DAYS_IN_YEAR = 365L;
    private String ogTime;
    private long millis;

    public TimeAPI(String string) {
        this.ogTime = string;
        this.reparse(string);
    }

    public TimeAPI(long l) {
        this.millis = l;
    }

    public void reparse(String string) {
        long l = 0L;
        TimeScanner timeScanner = new TimeScanner(string.replace(" ", "").replace("and", "").replace(",", "").toLowerCase());
        block48: while (timeScanner.hasNext()) {
            long l2 = timeScanner.nextLong();
            switch (timeScanner.nextString()) {
                case "ms": 
                case "millis": 
                case "milliseconds": {
                    l += l2;
                    continue block48;
                }
                case "s": 
                case "sec": 
                case "secs": 
                case "second": 
                case "seconds": {
                    l += TimeUnit.SECONDS.toMillis(l2);
                    continue block48;
                }
                case "m": 
                case "min": 
                case "mins": 
                case "minute": 
                case "minutes": {
                    l += TimeUnit.MINUTES.toMillis(l2);
                    continue block48;
                }
                case "h": 
                case "hr": 
                case "hrs": 
                case "hour": 
                case "hours": {
                    l += TimeUnit.HOURS.toMillis(l2);
                    continue block48;
                }
                case "d": 
                case "dy": 
                case "dys": 
                case "day": 
                case "days": {
                    l += TimeUnit.DAYS.toMillis(l2);
                    continue block48;
                }
                case "w": 
                case "week": 
                case "weeks": {
                    l += TimeUnit.DAYS.toMillis(l2 * 7L);
                    continue block48;
                }
                case "mo": 
                case "mon": 
                case "mnth": 
                case "month": 
                case "months": {
                    l += TimeUnit.DAYS.toMillis(l2 * 30L);
                    continue block48;
                }
                case "y": 
                case "yr": 
                case "yrs": 
                case "year": 
                case "years": {
                    l += TimeUnit.DAYS.toMillis(l2 * 365L);
                    continue block48;
                }
            }
            throw new IllegalArgumentException();
        }
        this.millis = l;
    }

    public String getOgTime() {
        return this.ogTime;
    }

    public long getNanoseconds() {
        return TimeUnit.MILLISECONDS.toNanos(this.millis);
    }

    public long getMicroseconds() {
        return TimeUnit.MILLISECONDS.toMicros(this.millis);
    }

    public long getMilliseconds() {
        return this.millis;
    }

    public long getSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.millis);
    }

    public long getMinutes() {
        return TimeUnit.MILLISECONDS.toMinutes(this.millis);
    }

    public long getHours() {
        return TimeUnit.MILLISECONDS.toHours(this.millis);
    }

    public long getDays() {
        return TimeUnit.MILLISECONDS.toDays(this.millis);
    }

    public long getWeeks() {
        return this.getDays() / 7L;
    }

    public long getMonths() {
        return this.getDays() / 30L;
    }

    public long getYears() {
        return this.getDays() / 365L;
    }

    public long getTicks() {
        return this.millis / 20000L;
    }
}

