/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import org.jsoup.Connection;
import org.jsoup.helper.DataUtil;
import org.jsoup.helper.HttpConnection;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Safelist;

public class Jsoup {
    private Jsoup() {
    }

    public static Document parse(String string, String string2) {
        return Parser.parse(string, string2);
    }

    public static Document parse(String string, String string2, Parser parser) {
        return parser.parseInput(string, string2);
    }

    public static Document parse(String string, Parser parser) {
        return parser.parseInput(string, "");
    }

    public static Document parse(String string) {
        return Parser.parse(string, "");
    }

    public static Connection connect(String string) {
        return HttpConnection.connect(string);
    }

    public static Connection newSession() {
        return new HttpConnection();
    }

    public static Document parse(File file, @Nullable String string, String string2) {
        return DataUtil.load(file, string, string2);
    }

    public static Document parse(File file, @Nullable String string) {
        return DataUtil.load(file, string, file.getAbsolutePath());
    }

    public static Document parse(File file) {
        return DataUtil.load(file, null, file.getAbsolutePath());
    }

    public static Document parse(File file, @Nullable String string, String string2, Parser parser) {
        return DataUtil.load(file, string, string2, parser);
    }

    public static Document parse(@WillClose InputStream inputStream, @Nullable String string, String string2) {
        return DataUtil.load(inputStream, string, string2);
    }

    public static Document parse(InputStream inputStream, @Nullable String string, String string2, Parser parser) {
        return DataUtil.load(inputStream, string, string2, parser);
    }

    public static Document parseBodyFragment(String string, String string2) {
        return Parser.parseBodyFragment(string, string2);
    }

    public static Document parseBodyFragment(String string) {
        return Parser.parseBodyFragment(string, "");
    }

    public static Document parse(URL uRL, int n) {
        Connection connection = HttpConnection.connect(uRL);
        connection.timeout(n);
        return connection.get();
    }

    public static String clean(String string, String string2, Safelist safelist) {
        Document document = Jsoup.parseBodyFragment(string, string2);
        Cleaner cleaner = new Cleaner(safelist);
        Document document2 = cleaner.clean(document);
        return document2.body().html();
    }

    public static String clean(String string, Safelist safelist) {
        return Jsoup.clean(string, "", safelist);
    }

    public static String clean(String string, String string2, Safelist safelist, Document.OutputSettings outputSettings) {
        Document document = Jsoup.parseBodyFragment(string, string2);
        Cleaner cleaner = new Cleaner(safelist);
        Document document2 = cleaner.clean(document);
        document2.outputSettings(outputSettings);
        return document2.body().html();
    }

    public static boolean isValid(String string, Safelist safelist) {
        return new Cleaner(safelist).isValidBodyHtml(string);
    }
}

