/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.jsoup.helper.Validate;

public final class StringUtil {
    static final String[] padding = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             ", "              ", "               ", "                ", "                 ", "                  ", "                   ", "                    "};
    private static final Pattern extraDotSegmentsPattern = Pattern.compile("^/((\\.{1,2}/)+)");
    private static final Pattern validUriScheme = Pattern.compile("^[a-zA-Z][a-zA-Z0-9+-.]*:");
    private static final Pattern controlChars = Pattern.compile("[\\x00-\\x1f]*");
    private static final ThreadLocal<Stack<StringBuilder>> threadLocalBuilders = new ThreadLocal<Stack<StringBuilder>>(){

        @Override
        protected Stack<StringBuilder> initialValue() {
            return new Stack<StringBuilder>();
        }
    };
    private static final int MaxCachedBuilderSize = 8192;
    private static final int MaxIdleBuilders = 8;

    public static String join(Collection<?> collection, String string) {
        return StringUtil.join(collection.iterator(), string);
    }

    public static String join(Iterator<?> iterator, String string) {
        if (!iterator.hasNext()) {
            return "";
        }
        String string2 = iterator.next().toString();
        if (!iterator.hasNext()) {
            return string2;
        }
        StringJoiner stringJoiner = new StringJoiner(string);
        stringJoiner.add(string2);
        while (iterator.hasNext()) {
            stringJoiner.add(iterator.next());
        }
        return stringJoiner.complete();
    }

    public static String join(String[] stringArray, String string) {
        return StringUtil.join(Arrays.asList(stringArray), string);
    }

    public static String padding(int n) {
        return StringUtil.padding(n, 30);
    }

    public static String padding(int n, int n2) {
        Validate.isTrue(n >= 0, "width must be >= 0");
        Validate.isTrue(n2 >= -1);
        if (n2 != -1) {
            n = Math.min(n, n2);
        }
        if (n < padding.length) {
            return padding[n];
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        return String.valueOf(cArray);
    }

    public static boolean isBlank(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (StringUtil.isWhitespace(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithNewline(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.charAt(0) == '\n';
    }

    public static boolean isNumeric(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 12 || n == 13;
    }

    public static boolean isActuallyWhitespace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 12 || n == 13 || n == 160;
    }

    public static boolean isInvisibleChar(int n) {
        return n == 8203 || n == 173;
    }

    public static String normaliseWhitespace(String string) {
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        StringUtil.appendNormalisedWhitespace(stringBuilder, string, false);
        return StringUtil.releaseBuilder(stringBuilder);
    }

    public static void appendNormalisedWhitespace(StringBuilder stringBuilder, String string, boolean bl) {
        int n;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (StringUtil.isActuallyWhitespace(n)) {
                if (bl && !bl3 || bl2) continue;
                stringBuilder.append(' ');
                bl2 = true;
                continue;
            }
            if (StringUtil.isInvisibleChar(n)) continue;
            stringBuilder.appendCodePoint(n);
            bl2 = false;
            bl3 = true;
        }
    }

    public static boolean in(String string, String ... stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean inSorted(String string, String[] stringArray) {
        return Arrays.binarySearch(stringArray, string) >= 0;
    }

    public static boolean isAscii(String string) {
        Validate.notNull(string);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static URL resolve(URL uRL, String string) {
        if ((string = StringUtil.stripControlChars(string)).startsWith("?")) {
            string = uRL.getPath() + string;
        }
        URL uRL2 = new URL(uRL, string);
        String string2 = extraDotSegmentsPattern.matcher(uRL2.getFile()).replaceFirst("/");
        if (uRL2.getRef() != null) {
            string2 = string2 + "#" + uRL2.getRef();
        }
        return new URL(uRL2.getProtocol(), uRL2.getHost(), uRL2.getPort(), string2);
    }

    public static String resolve(String string, String string2) {
        string = StringUtil.stripControlChars(string);
        string2 = StringUtil.stripControlChars(string2);
        try {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                URL uRL2 = new URL(string2);
                return uRL2.toExternalForm();
            }
            return StringUtil.resolve(uRL, string2).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return validUriScheme.matcher(string2).find() ? string2 : "";
        }
    }

    private static String stripControlChars(String string) {
        return controlChars.matcher(string).replaceAll("");
    }

    public static StringBuilder borrowBuilder() {
        Stack<StringBuilder> stack = threadLocalBuilders.get();
        return stack.empty() ? new StringBuilder(8192) : stack.pop();
    }

    public static String releaseBuilder(StringBuilder stringBuilder) {
        Validate.notNull(stringBuilder);
        String string = stringBuilder.toString();
        if (stringBuilder.length() > 8192) {
            stringBuilder = new StringBuilder(8192);
        } else {
            stringBuilder.delete(0, stringBuilder.length());
        }
        Stack<StringBuilder> stack = threadLocalBuilders.get();
        stack.push(stringBuilder);
        while (stack.size() > 8) {
            stack.pop();
        }
        return string;
    }

    public static class StringJoiner {
        @Nullable
        StringBuilder sb = StringUtil.borrowBuilder();
        final String separator;
        boolean first = true;

        public StringJoiner(String string) {
            this.separator = string;
        }

        public StringJoiner add(Object object) {
            Validate.notNull(this.sb);
            if (!this.first) {
                this.sb.append(this.separator);
            }
            this.sb.append(object);
            this.first = false;
            return this;
        }

        public StringJoiner append(Object object) {
            Validate.notNull(this.sb);
            this.sb.append(object);
            return this;
        }

        public String complete() {
            String string = StringUtil.releaseBuilder(this.sb);
            this.sb = null;
            return string;
        }
    }
}

