/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.List;
import org.jsoup.helper.Validate;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.HtmlTreeBuilder;
import org.jsoup.parser.Parser;
import org.w3c.dom.NodeList;

final class NodeUtils {
    NodeUtils() {
    }

    static Document.OutputSettings outputSettings(Node node) {
        Document document = node.ownerDocument();
        return document != null ? document.outputSettings() : new Document("").outputSettings();
    }

    static Parser parser(Node node) {
        Document document = node.ownerDocument();
        return document != null && document.parser() != null ? document.parser() : new Parser(new HtmlTreeBuilder());
    }

    static <T extends Node> List<T> selectXpath(String string, Element element, Class<T> clazz) {
        Validate.notEmpty(string);
        Validate.notNull(element);
        Validate.notNull(clazz);
        W3CDom w3CDom = new W3CDom().namespaceAware(false);
        org.w3c.dom.Document document = w3CDom.fromJsoup(element);
        org.w3c.dom.Node node = w3CDom.contextNode(document);
        NodeList nodeList = w3CDom.selectXpath(string, node);
        return w3CDom.sourceNodes(nodeList, clazz);
    }
}

