/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import javax.annotation.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class Collector {
    private Collector() {
    }

    public static Elements collect(Evaluator evaluator, Element element) {
        Elements elements = new Elements();
        NodeTraversor.traverse((NodeVisitor)new Accumulator(element, elements, evaluator), element);
        return elements;
    }

    @Nullable
    public static Element findFirst(Evaluator evaluator, Element element) {
        FirstFinder firstFinder = new FirstFinder(evaluator);
        return firstFinder.find(element, element);
    }

    private static class Accumulator
    implements NodeVisitor {
        private final Element root;
        private final Elements elements;
        private final Evaluator eval;

        Accumulator(Element element, Elements elements, Evaluator evaluator) {
            this.root = element;
            this.elements = elements;
            this.eval = evaluator;
        }

        @Override
        public void head(Node node, int n) {
            Element element;
            if (node instanceof Element && this.eval.matches(this.root, element = (Element)node)) {
                this.elements.add(element);
            }
        }

        @Override
        public void tail(Node node, int n) {
        }
    }

    static class FirstFinder
    implements NodeFilter {
        @Nullable
        private Element evalRoot = null;
        @Nullable
        private Element match = null;
        private final Evaluator eval;

        FirstFinder(Evaluator evaluator) {
            this.eval = evaluator;
        }

        @Nullable
        Element find(Element element, Element element2) {
            this.evalRoot = element;
            this.match = null;
            NodeTraversor.filter((NodeFilter)this, element2);
            return this.match;
        }

        @Override
        public NodeFilter.FilterResult head(Node node, int n) {
            Element element;
            if (node instanceof Element && this.eval.matches(this.evalRoot, element = (Element)node)) {
                this.match = element;
                return NodeFilter.FilterResult.STOP;
            }
            return NodeFilter.FilterResult.CONTINUE;
        }

        @Override
        public NodeFilter.FilterResult tail(Node node, int n) {
            return NodeFilter.FilterResult.CONTINUE;
        }
    }
}

