/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Element;
import org.jsoup.select.Evaluator;

public abstract class CombiningEvaluator
extends Evaluator {
    final ArrayList<Evaluator> evaluators = new ArrayList();
    int num = 0;

    CombiningEvaluator() {
    }

    CombiningEvaluator(Collection<Evaluator> collection) {
        this();
        this.evaluators.addAll(collection);
        this.updateNumEvaluators();
    }

    @Nullable
    Evaluator rightMostEvaluator() {
        return this.num > 0 ? this.evaluators.get(this.num - 1) : null;
    }

    void replaceRightMostEvaluator(Evaluator evaluator) {
        this.evaluators.set(this.num - 1, evaluator);
    }

    void updateNumEvaluators() {
        this.num = this.evaluators.size();
    }

    public static final class Or
    extends CombiningEvaluator {
        Or(Collection<Evaluator> collection) {
            if (this.num > 1) {
                this.evaluators.add(new And(collection));
            } else {
                this.evaluators.addAll(collection);
            }
            this.updateNumEvaluators();
        }

        Or(Evaluator ... evaluatorArray) {
            this(Arrays.asList(evaluatorArray));
        }

        Or() {
        }

        public void add(Evaluator evaluator) {
            this.evaluators.add(evaluator);
            this.updateNumEvaluators();
        }

        @Override
        public boolean matches(Element element, Element element2) {
            for (int i = 0; i < this.num; ++i) {
                Evaluator evaluator = (Evaluator)this.evaluators.get(i);
                if (!evaluator.matches(element, element2)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return StringUtil.join(this.evaluators, ", ");
        }
    }

    public static final class And
    extends CombiningEvaluator {
        And(Collection<Evaluator> collection) {
            super(collection);
        }

        And(Evaluator ... evaluatorArray) {
            this(Arrays.asList(evaluatorArray));
        }

        @Override
        public boolean matches(Element element, Element element2) {
            for (int i = this.num - 1; i >= 0; --i) {
                Evaluator evaluator = (Evaluator)this.evaluators.get(i);
                if (evaluator.matches(element, element2)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return StringUtil.join(this.evaluators, "");
        }
    }
}

