/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.bungeecord;

import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.platform.bungeecord.BungeeAudience;
import net.kyori.adventure.platform.bungeecord.BungeeAudiences;
import net.kyori.adventure.platform.bungeecord.BungeeFacet;
import net.kyori.adventure.platform.facet.FacetAudienceProvider;
import net.kyori.adventure.platform.facet.Knob;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import org.jetbrains.annotations.NotNull;

final class BungeeAudiencesImpl
extends FacetAudienceProvider<CommandSender, BungeeAudience>
implements BungeeAudiences {
    private static final Map<String, BungeeAudiences> INSTANCES;
    private final Plugin plugin;
    private final Listener listener;

    @NotNull
    static BungeeAudiences instanceFor(@NotNull Plugin plugin) {
        return BungeeAudiencesImpl.builder(plugin).build();
    }

    @NotNull
    static Builder builder(@NotNull Plugin plugin) {
        return new Builder(plugin);
    }

    BungeeAudiencesImpl(Plugin plugin, @NotNull ComponentRenderer<Pointered> componentRenderer) {
        super(componentRenderer);
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.listener = new Listener();
        this.plugin.getProxy().getPluginManager().registerListener(this.plugin, (net.md_5.bungee.api.plugin.Listener)this.listener);
        CommandSender commandSender = this.plugin.getProxy().getConsole();
        this.addViewer(commandSender);
        for (ProxiedPlayer proxiedPlayer : this.plugin.getProxy().getPlayers()) {
            this.addViewer(proxiedPlayer);
        }
    }

    @Override
    @NotNull
    public Audience sender(@NotNull CommandSender commandSender) {
        if (commandSender instanceof ProxiedPlayer) {
            return this.player((ProxiedPlayer)commandSender);
        }
        if (ProxyServer.getInstance().getConsole().equals(commandSender)) {
            return this.console();
        }
        return this.createAudience(Collections.singletonList(commandSender));
    }

    @Override
    @NotNull
    public Audience player(@NotNull ProxiedPlayer proxiedPlayer) {
        return this.player(proxiedPlayer.getUniqueId());
    }

    @Override
    @NotNull
    protected BungeeAudience createAudience(@NotNull Collection<CommandSender> collection) {
        return new BungeeAudience(this, collection);
    }

    @Override
    @NotNull
    public ComponentFlattener flattener() {
        return BungeeFacet.FLATTENER;
    }

    @Override
    public void close() {
        this.plugin.getProxy().getPluginManager().unregisterListener((net.md_5.bungee.api.plugin.Listener)this.listener);
        super.close();
    }

    static {
        Knob.OUT = string -> ProxyServer.getInstance().getLogger().log(Level.INFO, (String)string);
        Knob.ERR = (string, throwable) -> ProxyServer.getInstance().getLogger().log(Level.WARNING, (String)string, (Throwable)throwable);
        try {
            Field field = ProxyServer.getInstance().getClass().getDeclaredField("gson");
            field.setAccessible(true);
            Gson gson = (Gson)field.get(ProxyServer.getInstance());
            BungeeComponentSerializer.inject(gson);
        }
        catch (Throwable throwable2) {
            Knob.logError(throwable2, "Failed to inject ProxyServer gson", new Object[0]);
        }
        INSTANCES = Collections.synchronizedMap(new HashMap(4));
    }

    public final class Listener
    implements net.md_5.bungee.api.plugin.Listener {
        @EventHandler(priority=-128)
        public void onLogin(PostLoginEvent postLoginEvent) {
            BungeeAudiencesImpl.this.addViewer(postLoginEvent.getPlayer());
        }

        @EventHandler(priority=127)
        public void onDisconnect(PlayerDisconnectEvent playerDisconnectEvent) {
            BungeeAudiencesImpl.this.removeViewer(playerDisconnectEvent.getPlayer());
        }
    }

    static final class Builder
    implements BungeeAudiences.Builder {
        @NotNull
        private final Plugin plugin;
        private ComponentRenderer<Pointered> componentRenderer;

        Builder(@NotNull Plugin plugin) {
            this.plugin = Objects.requireNonNull(plugin, "plugin");
            this.componentRenderer(pointered -> pointered.getOrDefault(Identity.LOCALE, DEFAULT_LOCALE), GlobalTranslator.renderer());
        }

        @Override
        @NotNull
        public Builder componentRenderer(@NotNull ComponentRenderer<Pointered> componentRenderer) {
            this.componentRenderer = Objects.requireNonNull(componentRenderer, "component renderer");
            return this;
        }

        @Override
        public @NotNull BungeeAudiences.Builder partition(@NotNull Function<Pointered, ?> function) {
            Objects.requireNonNull(function, "partitionFunction");
            return this;
        }

        @Override
        @NotNull
        public BungeeAudiences build() {
            return INSTANCES.computeIfAbsent(this.plugin.getDescription().getName(), string -> new BungeeAudiencesImpl(this.plugin, this.componentRenderer));
        }
    }
}

