/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.standard;

import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.internal.serializer.QuotingOverride;
import net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import net.kyori.adventure.text.minimessage.internal.serializer.StyleClaim;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.Nullable;

final class ClickTag {
    private static final String CLICK = "click";
    static final TagResolver RESOLVER = SerializableResolver.claimingStyle("click", ClickTag::create, StyleClaim.claim("click", Style::clickEvent, (clickEvent, tokenEmitter) -> tokenEmitter.tag(CLICK).argument(ClickEvent.Action.NAMES.key(clickEvent.action())).argument(clickEvent.value(), QuotingOverride.QUOTED)));

    private ClickTag() {
    }

    static Tag create(ArgumentQueue argumentQueue, Context context) {
        String string = argumentQueue.popOr(() -> "A click tag requires an action of one of " + ClickEvent.Action.NAMES.keys()).lowerValue();
        @Nullable ClickEvent.Action action = ClickEvent.Action.NAMES.value(string);
        if (action == null) {
            throw context.newException("Unknown click event action '" + string + "'", argumentQueue);
        }
        String string2 = argumentQueue.popOr("Click event actions require a value").value();
        return Tag.styling(ClickEvent.clickEvent(action, string2));
    }
}

