/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.api.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServerInfo;
import us.ajg0702.queue.api.server.AdaptedServerPing;
import us.ajg0702.queue.api.util.Handle;
import us.ajg0702.queue.api.util.QueueLogger;

public interface AdaptedServer
extends Handle {
    public AdaptedServerInfo getServerInfo();

    public String getName();

    default public CompletableFuture<AdaptedServerPing> ping() {
        return this.ping(false, null);
    }

    public CompletableFuture<AdaptedServerPing> ping(boolean var1, QueueLogger var2);

    public Optional<AdaptedServerPing> getLastPing();

    public boolean canAccess(AdaptedPlayer var1);

    public List<AdaptedPlayer> getPlayers();

    public int getOfflineTime();

    public boolean canJoinFull(AdaptedPlayer var1);

    public boolean justWentOnline();

    default public boolean isJoinable(AdaptedPlayer player) {
        if (player != null) {
            if (this.isWhitelisted() && !this.getWhitelistedPlayers().contains(player.getUniqueId())) {
                return false;
            }
            if (this.isFull() && !this.canJoinFull(player)) {
                return false;
            }
        }
        return this.isOnline() && this.canAccess(player);
    }

    default public boolean isFull() {
        if (!this.getLastPing().isPresent()) {
            return false;
        }
        return this.getLastPing().get().getPlayerCount() >= this.getLastPing().get().getMaxPlayers();
    }

    default public boolean isOnline() {
        return this.getLastPing().isPresent();
    }

    default public int getPlayerCount() {
        if (!this.getLastPing().isPresent()) {
            return 0;
        }
        AdaptedServerPing ping = this.getLastPing().get();
        return ping.getPlayerCount();
    }

    default public int getMaxPlayers() {
        if (!this.getLastPing().isPresent()) {
            return 0;
        }
        AdaptedServerPing ping = this.getLastPing().get();
        return ping.getMaxPlayers();
    }

    default public void addPlayer() {
        if (!this.getLastPing().isPresent()) {
            return;
        }
        this.getLastPing().get().addPlayer();
    }

    default public boolean isWhitelisted() {
        if (!this.getLastPing().isPresent()) {
            return false;
        }
        return this.getLastPing().get().getPlainDescription().contains("ajQueue;whitelisted=");
    }

    default public List<UUID> getWhitelistedPlayers() {
        if (!this.getLastPing().isPresent()) {
            return Collections.emptyList();
        }
        if (!this.isWhitelisted()) {
            return Collections.emptyList();
        }
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (String uuid : this.getLastPing().get().getPlainDescription().substring(20).split(",")) {
            UUID parsedUUID;
            if (uuid.isEmpty()) continue;
            try {
                parsedUUID = UUID.fromString(uuid);
            }
            catch (IllegalArgumentException ignored) {
                continue;
            }
            uuids.add(parsedUUID);
        }
        return uuids;
    }
}

