/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.SlashServer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.commands.BaseCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class SlashServerCommand
extends BaseCommand {
    final QueueMain main;
    final String server;
    final String command;

    public SlashServerCommand(QueueMain queueMain, String string) {
        this.main = queueMain;
        this.server = string;
        this.command = string;
    }

    public SlashServerCommand(QueueMain queueMain, String string, String string2) {
        this.main = queueMain;
        this.server = string2;
        this.command = string;
    }

    @Override
    public String getName() {
        return this.command;
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return this.main.getConfig().getBoolean("require-permission") ? "ajqueue.queue." + this.server : null;
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender iCommandSender, String[] stringArray) {
        if (!iCommandSender.isPlayer()) {
            iCommandSender.sendMessage(this.getMessages().getComponent("errors.player-only", new String[0]));
            return;
        }
        if (this.main.getConfig().getBoolean("require-permission") && !iCommandSender.hasPermission("ajqueue.queue." + this.server)) {
            iCommandSender.sendMessage(this.getMessages().getComponent("noperm", new String[0]));
            return;
        }
        this.main.getQueueManager().addToQueue(this.main.getPlatformMethods().senderToPlayer(iCommandSender), this.server);
    }

    @Override
    public List<String> autoComplete(ICommandSender iCommandSender, String[] stringArray) {
        return new ArrayList<String>();
    }
}

