/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.commands.SubCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class Kick
extends SubCommand {
    final QueueMain main;

    public Kick(QueueMain queueMain) {
        this.main = queueMain;
    }

    @Override
    public String getName() {
        return "kick";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return "ajqueue.manage.kick";
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender iCommandSender, String[] stringArray) {
        Object object;
        Object object2;
        if (!this.checkPermission(iCommandSender)) {
            return;
        }
        if (stringArray.length < 1) {
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.kick.usage", new String[0]));
            return;
        }
        if (stringArray.length == 1) {
            object2 = this.main.getQueueManager().findPlayerInQueuesByName(stringArray[0]);
        } else {
            object = this.main.getQueueManager().findServer(stringArray[1]);
            if (object == null) {
                iCommandSender.sendMessage(this.getMessages().getComponent("commands.kick.unknown-server", "QUEUE:" + stringArray[1]));
                return;
            }
            object2 = Collections.singletonList(object.findPlayer(stringArray[0]));
        }
        if (object2.size() == 0) {
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.kick.no-player", "PLAYER:" + stringArray[0]));
            return;
        }
        object = object2.iterator();
        while (object.hasNext()) {
            QueuePlayer queuePlayer = (QueuePlayer)object.next();
            queuePlayer.getQueueServer().removePlayer(queuePlayer);
        }
        iCommandSender.sendMessage(this.getMessages().getComponent("commands.kick.success", "PLAYER:" + stringArray[0], "NUM:" + object2.size(), "s:" + (object2.size() == 1 ? "" : "s")));
    }

    @Override
    public List<String> autoComplete(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length == 1) {
            return this.main.getPlatformMethods().getPlayerNames(false);
        }
        if (stringArray.length == 2) {
            return this.main.getQueueManager().getServerNames();
        }
        return new ArrayList<String>();
    }
}

