/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.commands.SubCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class KickAll
extends SubCommand {
    final QueueMain main;

    public KickAll(QueueMain queueMain) {
        this.main = queueMain;
    }

    @Override
    public String getName() {
        return "kickall";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return "ajqueue.manage.kickall";
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender iCommandSender, String[] stringArray) {
        if (!this.checkPermission(iCommandSender)) {
            return;
        }
        if (stringArray.length < 1) {
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.kickall.usage", new String[0]));
            return;
        }
        QueueServer queueServer = this.main.getQueueManager().findServer(stringArray[0]);
        ArrayList<QueuePlayer> arrayList = new ArrayList<QueuePlayer>((Collection<QueuePlayer>)queueServer.getQueue());
        for (QueuePlayer queuePlayer : arrayList) {
            queuePlayer.getQueueServer().removePlayer(queuePlayer);
        }
        iCommandSender.sendMessage(this.getMessages().getComponent("commands.kickall.success", "SERVER:" + stringArray[0], "NUM:" + arrayList.size(), "s:" + (arrayList.size() == 1 ? "" : "s")));
    }

    @Override
    public List<String> autoComplete(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length == 1) {
            return this.main.getQueueManager().getServerNames();
        }
        return new ArrayList<String>();
    }
}

