/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import us.ajg0702.queue.api.AjQueueAPI;
import us.ajg0702.queue.api.AliasManager;
import us.ajg0702.queue.api.EventHandler;
import us.ajg0702.queue.api.Implementation;
import us.ajg0702.queue.api.PlatformMethods;
import us.ajg0702.queue.api.ProtocolNameManager;
import us.ajg0702.queue.api.QueueManager;
import us.ajg0702.queue.api.events.Event;
import us.ajg0702.queue.api.events.utils.EventReceiver;
import us.ajg0702.queue.api.premium.Logic;
import us.ajg0702.queue.api.premium.LogicGetter;
import us.ajg0702.queue.api.util.QueueLogger;
import us.ajg0702.queue.common.EventHandlerImpl;
import us.ajg0702.queue.common.ProtocolNameManagerImpl;
import us.ajg0702.queue.common.QueueManagerImpl;
import us.ajg0702.queue.common.SlashServerManager;
import us.ajg0702.queue.common.TaskManager;
import us.ajg0702.queue.common.utils.LogConverter;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurateException;
import us.ajg0702.queue.libs.utils.common.Config;
import us.ajg0702.queue.libs.utils.common.Messages;
import us.ajg0702.queue.libs.utils.common.Updater;
import us.ajg0702.queue.logic.LogicGetterImpl;

public class QueueMain
extends AjQueueAPI {
    private static QueueMain instance;
    private double timeBetweenPlayers;
    private Config config;
    private Messages messages;
    private AliasManager aliasManager;
    private Logic logic;
    private final PlatformMethods platformMethods;
    private final QueueLogger logger;
    private final TaskManager taskManager = new TaskManager(this);
    private final EventHandler eventHandler = new EventHandlerImpl(this);
    private QueueManager queueManager;
    private final LogicGetter logicGetter;
    private ProtocolNameManager protocolNameManager;
    private Updater updater;
    private final Implementation implementation;
    private SlashServerManager slashServerManager;
    private final Map<Class<?>, ArrayList<EventReceiver<Event>>> listeners = new ConcurrentHashMap();
    private final File dataFolder;

    public static QueueMain getInstance() {
        return instance;
    }

    @Override
    public double getTimeBetweenPlayers() {
        return this.timeBetweenPlayers;
    }

    @Override
    public void setTimeBetweenPlayers() {
        this.timeBetweenPlayers = this.config.getDouble("wait-time");
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public Messages getMessages() {
        return this.messages;
    }

    @Override
    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    @Override
    public Logic getLogic() {
        return this.logic;
    }

    @Override
    public boolean isPremium() {
        return this.getLogic().isPremium();
    }

    @Override
    public PlatformMethods getPlatformMethods() {
        return this.platformMethods;
    }

    @Override
    public QueueLogger getLogger() {
        return this.logger;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    @Override
    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    @Override
    public LogicGetter getLogicGetter() {
        return this.logicGetter;
    }

    @Override
    public ProtocolNameManager getProtocolNameManager() {
        return this.protocolNameManager;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public Implementation getImplementation() {
        return this.implementation;
    }

    public SlashServerManager getSlashServerManager() {
        return this.slashServerManager;
    }

    @Override
    public void shutdown() {
        this.taskManager.shutdown();
        this.updater.shutdown();
    }

    @Override
    public <E> void listen(Class<E> clazz2, EventReceiver<E> eventReceiver) {
        if (!Arrays.asList(clazz2.getInterfaces()).contains(Event.class)) {
            throw new IllegalArgumentException("You can only listen to ajQueue events!");
        }
        List list = this.listeners.computeIfAbsent(clazz2, clazz -> new ArrayList());
        list.add(event -> eventReceiver.execute(event));
    }

    public void call(Event event) {
        List list = this.listeners.computeIfAbsent(event.getClass(), clazz -> new ArrayList());
        list.forEach(eventReceiver -> {
            try {
                eventReceiver.execute(event);
            }
            catch (Exception exception) {
                this.logger.severe("An external plugin threw an error while handling an event (this is probably not the fault of ajQueue!)", exception);
            }
        });
    }

    @Override
    public ExecutorService getServersUpdateExecutor() {
        return this.taskManager.getServersUpdateExecutor();
    }

    public QueueMain(Implementation implementation, QueueLogger queueLogger, PlatformMethods platformMethods, File file) {
        this.implementation = implementation;
        this.logicGetter = new LogicGetterImpl();
        if (instance != null) {
            try {
                throw new Exception("ajQueue QueueMain is being initialized when there is already one! Still initializing it, but this can cause issues.");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        instance = this;
        AjQueueAPI.INSTANCE = this;
        this.logger = queueLogger;
        this.platformMethods = platformMethods;
        this.dataFolder = file;
        this.constructMessages();
        try {
            this.config = new Config(file, new LogConverter(queueLogger));
        }
        catch (ConfigurateException configurateException) {
            queueLogger.warning("Unable to load config:");
            configurateException.printStackTrace();
            return;
        }
        this.logic = this.logicGetter.constructLogic();
        this.aliasManager = this.logicGetter.constructAliasManager(this.config);
        this.slashServerManager = new SlashServerManager(this);
        this.messages.getComponent("one", new String[0]).replaceText(builder -> builder.match(Pattern.compile("\\e")).replacement("a"));
        this.setTimeBetweenPlayers();
        this.queueManager = new QueueManagerImpl(this);
        this.protocolNameManager = new ProtocolNameManagerImpl(this.config, platformMethods);
        this.taskManager.rescheduleTasks();
        this.updater = new Updater(queueLogger, platformMethods.getPluginVersion(), this.isPremium() ? "ajQueuePlus" : "ajQueue", this.config.getBoolean("enable-updater"), this.isPremium() ? 79123 : 78266, file.getParentFile(), "ajQueue update");
    }

    private void constructMessages() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("status.offline.base", "&c{SERVER} is {STATUS}. &7You are in position &f{POS}&7 of &f{LEN}&7.");
        linkedHashMap.put("status.offline.offline", "offline");
        linkedHashMap.put("status.offline.restarting", "restarting");
        linkedHashMap.put("status.offline.full", "full");
        linkedHashMap.put("status.offline.restricted", "restricted");
        linkedHashMap.put("status.offline.paused", "paused");
        linkedHashMap.put("status.offline.whitelisted", "whitelisted");
        linkedHashMap.put("status.online.base", "&7You are in position &f{POS}&7 of &f{LEN}&7. Estimated time: {TIME}");
        linkedHashMap.put("status.left-last-queue", "&aYou left the last queue you were in.");
        linkedHashMap.put("status.now-in-queue", "&aYou are now queued for {SERVER}! &7You are in position &f{POS}&7 of &f{LEN}&7.\n&7Type &f/leavequeue&7 or &f<click:run_command:/leavequeue {SERVERNAME}>click here</click>&7 to leave the queue!");
        linkedHashMap.put("status.now-in-empty-queue", "");
        linkedHashMap.put("status.sending-now", "&aSending you to &f{SERVER} &anow..");
        linkedHashMap.put("errors.server-not-exist", "&cThe server {SERVER} does not exist!");
        linkedHashMap.put("errors.already-queued", "&cYou are already queued for that server!");
        linkedHashMap.put("errors.player-only", "&cThis command can only be executed as a player!");
        linkedHashMap.put("errors.already-connected", "&cYou are already connected to this server!");
        linkedHashMap.put("errors.cant-join-paused", "&cYou cannot join the queue for {SERVER} because it is paused.");
        linkedHashMap.put("errors.deny-joining-from-server", "&cYou are not allowed to join queues from this server!");
        linkedHashMap.put("errors.wrong-version.base", "<red>You must be on {VERSIONS} to join this server!");
        linkedHashMap.put("errors.wrong-version.or", " or ");
        linkedHashMap.put("errors.wrong-version.comma", ", ");
        linkedHashMap.put("errors.too-fast-queue", "<red>You're queueing too fast!");
        linkedHashMap.put("commands.leave-queue", "&aYou left the queue for {SERVER}!");
        linkedHashMap.put("commands.reload", "&aConfig and messages reloaded successfully!");
        linkedHashMap.put("commands.joinqueue.usage", "&cUsage: /joinqueue <server>");
        linkedHashMap.put("commands.kick.usage", "<red>Usage: /ajqueue kick <player> [queue]");
        linkedHashMap.put("commands.kick.no-player", "&cCould not find {PLAYER}! Make sure they are in a queue!");
        linkedHashMap.put("commands.kick.unknown-server", "&cCould not find queue {QUEUE}. Make sure you spelled it correctly!");
        linkedHashMap.put("commands.kick.success", "<green>Kicked <white>{PLAYER} <green>from {NUM} queue{s}!");
        linkedHashMap.put("commands.kickall.usage", "<red>Usage: /ajqueue kickall <queue>");
        linkedHashMap.put("commands.kickall.success", "<green>Kicked <white>{NUM} <green>player{s} from <white>{SERVER}<green>!");
        linkedHashMap.put("commands.pausequeueserver.unpaused", "<green>You are no longer paused! <gray>You can now use queue-servers normally.");
        linkedHashMap.put("commands.pausequeueserver.paused", "<green>You are now paused! <gray>You will no longer be sent using queue-servers.");
        linkedHashMap.put("commands.pausequeueserver.reminder", "<gold>Reminder: <yellow>You are currently paused for queue-servers, so you will not be sent using them!<gray> Use <white>/ajQueue pausequeueserver</white> to un-pause and return to normal behaviour");
        linkedHashMap.put("noperm", "&cYou do not have permission to do this!");
        linkedHashMap.put("format.time.mins", "{m}m {s}s");
        linkedHashMap.put("format.time.secs", "{s} seconds");
        linkedHashMap.put("list.format", "&b{SERVER} &7({COUNT}): {LIST}");
        linkedHashMap.put("list.playerlist", "&9{NAME}&7, ");
        linkedHashMap.put("list.total", "&7Total players in queues: &f{TOTAL}");
        linkedHashMap.put("list.none", "&7None");
        linkedHashMap.put("spigot.actionbar.online", "&7You are queued for &f{SERVER}&7. You are in position &f{POS}&7 of &f{LEN}&7. Estimated time: {TIME}");
        linkedHashMap.put("spigot.actionbar.offline", "&7You are queued for &f{SERVER}&7. &7You are in position &f{POS}&7 of &f{LEN}&7.");
        linkedHashMap.put("send", "&aAdded &f{PLAYER}&a to the queue for &f{SERVER}");
        linkedHashMap.put("remove", "&aRemoved &f{PLAYER} from all queues they were in.");
        linkedHashMap.put("placeholders.queued.none", "None");
        linkedHashMap.put("placeholders.position.none", "None");
        linkedHashMap.put("placeholders.estimated_time.none", "None");
        linkedHashMap.put("placeholders.status.online", "&aOnline");
        linkedHashMap.put("placeholders.status.offline", "&cOffline");
        linkedHashMap.put("placeholders.status.restarting", "&cRestarting");
        linkedHashMap.put("placeholders.status.full", "&eFull");
        linkedHashMap.put("placeholders.status.restricted", "&eRestricted");
        linkedHashMap.put("placeholders.status.paused", "&ePaused");
        linkedHashMap.put("placeholders.status.whitelisted", "&eWhitelisted");
        linkedHashMap.put("title.title", "");
        linkedHashMap.put("title.subtitle", "<gold>You are <green>#{POS} <gold>in the queue!");
        linkedHashMap.put("title.sending-now.title", "");
        linkedHashMap.put("title.sending-now.subtitle", "<green>Sending you to <white>{SERVER} <green>now..");
        linkedHashMap.put("commands.leave.more-args", "&cPlease specify which queue you want to leave! &7You are in these queues: {QUEUES}");
        linkedHashMap.put("commands.leave.queues-list-format", "&f{NAME}&7, ");
        linkedHashMap.put("commands.leave.not-queued", "&cYou are not queued for that server! &7You are in these queues: {QUEUES}");
        linkedHashMap.put("commands.leave.no-queues", "&cYou are not queued!");
        linkedHashMap.put("commands.pause.more-args", "&cUsage: /ajqueue pause <server> [on/off]");
        linkedHashMap.put("commands.pause.no-server", "&cThat server does not exist!");
        linkedHashMap.put("commands.pause.success", "&aThe queue for &f{SERVER} &ais now {PAUSED}");
        linkedHashMap.put("commands.pause.paused.true", "&epaused");
        linkedHashMap.put("commands.pause.paused.false", "&aun-paused");
        linkedHashMap.put("commands.send.player-not-found", "&cThat player could not be found. Make sure they are online!");
        linkedHashMap.put("commands.send.usage", "<red>Usage: /ajqueue send <player> <server>");
        linkedHashMap.put("commands.listqueues.header", "&9Queues:");
        linkedHashMap.put("commands.listqueues.format", "<hover:show_text:'&7Status: {STATUS}'>{COLOR}{NAME}&7: {COUNT} queued</hover>");
        linkedHashMap.put("max-tries-reached", "&cUnable to connect to {SERVER}. Max retries reached.");
        linkedHashMap.put("auto-queued", "&aYou've been auto-queued for {SERVER} because you were kicked.");
        linkedHashMap.put("velocity-kick-message", "<red>You were kicked while trying to join {SERVER}: <white>{REASON}");
        linkedHashMap.put("updater.update-available", "<gray><strikethrough>                                                         <reset>\n  <green>An update is available for ajQueue!\n  <dark_green>You can download it by <click:run_command:/ajqueue update><bold>clicking here</bold>\n    or running <gray>/ajQueue update</click>\n<gray><strikethrough>                                                         <reset>");
        linkedHashMap.put("updater.no-update", "<red>There is not an update available");
        linkedHashMap.put("updater.success", "<green>The update has been downloaded! Now just restart the server");
        linkedHashMap.put("updater.fail", "<red>An error occurred while downloading the update. Check the console for more info.");
        linkedHashMap.put("updater.already-downloaded", "<red>The update has already been downloaded.");
        this.messages = new Messages(this.dataFolder, new LogConverter(this.logger), linkedHashMap);
    }
}

