/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common.queues;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import us.ajg0702.queue.api.events.PositionChangeEvent;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queues.Balancer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.common.players.QueuePlayerImpl;
import us.ajg0702.queue.common.queues.balancers.DefaultBalancer;
import us.ajg0702.queue.common.queues.balancers.MinigameBalancer;
import us.ajg0702.queue.common.utils.Debug;
import us.ajg0702.queue.libs.utils.common.Messages;

public class QueueServerImpl
implements QueueServer {
    private final String name;
    private final QueueMain main;
    private final List<AdaptedServer> servers;
    private final List<QueuePlayer> queue = new ArrayList<QueuePlayer>();
    private List<Integer> supportedProtocols = new ArrayList<Integer>();
    private Balancer balancer;
    private boolean paused;
    private long lastSentTime = 0L;

    public QueueServerImpl(String string, QueueMain queueMain, AdaptedServer adaptedServer, List<QueuePlayer> list) {
        this(string, queueMain, Collections.singletonList(adaptedServer), list);
    }

    public QueueServerImpl(String string, QueueMain queueMain, List<AdaptedServer> list, List<QueuePlayer> list2) {
        this.name = string;
        this.servers = list;
        this.main = queueMain;
        List<String> list3 = queueMain.getConfig().getStringList("balancer-types");
        for (String object : list3) {
            int n = object.indexOf(":");
            if (n == -1) continue;
            String string2 = object.substring(0, n);
            String string3 = object.substring(n + 1);
            if (!string2.equals(string)) continue;
            switch (string3.toLowerCase(Locale.ROOT)) {
                case "minigame": {
                    this.balancer = new MinigameBalancer(this, queueMain);
                    break;
                }
                default: {
                    string3 = "default";
                    this.balancer = new DefaultBalancer(this, queueMain);
                }
            }
            Debug.info("Using " + string3.toLowerCase(Locale.ROOT) + " balancer for " + string);
            break;
        }
        if (this.balancer == null) {
            this.balancer = new DefaultBalancer(this, queueMain);
            Debug.info("Using default balancer for " + string);
        }
        for (QueuePlayer queuePlayer : list2) {
            if (queuePlayer.getPlayer() == null) {
                this.addPlayer(new QueuePlayerImpl(queuePlayer.getUniqueId(), queuePlayer.getName(), this, queuePlayer.getPriority(), queuePlayer.getMaxOfflineTime()));
                continue;
            }
            this.addPlayer(new QueuePlayerImpl(queuePlayer.getPlayer(), this, queuePlayer.getPriority(), queuePlayer.getMaxOfflineTime()));
        }
    }

    @Override
    public ImmutableList<QueuePlayer> getQueue() {
        return ImmutableList.copyOf(this.queue);
    }

    @Override
    public String getStatusString(AdaptedPlayer adaptedPlayer) {
        Messages messages = this.main.getMessages();
        AdaptedServer adaptedServer = this.getIdealServer(adaptedPlayer);
        if (adaptedServer.getOfflineTime() > this.main.getConfig().getInt("offline-time")) {
            return messages.getString("status.offline.offline", new String[0]);
        }
        if (!adaptedServer.isOnline()) {
            return messages.getString("status.offline.restarting", new String[0]);
        }
        if (this.isPaused()) {
            return messages.getString("status.offline.paused", new String[0]);
        }
        if (adaptedPlayer != null && adaptedServer.isWhitelisted() && !adaptedServer.getWhitelistedPlayers().contains(adaptedPlayer.getUniqueId())) {
            return messages.getString("status.offline.whitelisted", new String[0]);
        }
        if (adaptedServer.isFull() && !adaptedServer.canJoinFull(adaptedPlayer)) {
            return messages.getString("status.offline.full", new String[0]);
        }
        if (adaptedPlayer != null && !this.canAccess(adaptedPlayer)) {
            return messages.getString("status.offline.restricted", new String[0]);
        }
        return "online";
    }

    @Override
    public String getStatusString() {
        return this.getStatusString(null);
    }

    @Override
    public String getStatus(AdaptedPlayer adaptedPlayer) {
        AdaptedServer adaptedServer = this.getIdealServer(adaptedPlayer);
        if (adaptedServer.getOfflineTime() > this.main.getConfig().getInt("offline-time")) {
            return "offline";
        }
        if (!adaptedServer.isOnline()) {
            return "restarting";
        }
        if (this.isPaused()) {
            return "paused";
        }
        if (adaptedPlayer != null && adaptedServer.isWhitelisted() && !adaptedServer.getWhitelistedPlayers().contains(adaptedPlayer.getUniqueId())) {
            return "whitelisted";
        }
        if (adaptedServer.isFull() && !adaptedServer.canJoinFull(adaptedPlayer)) {
            return "full";
        }
        if (adaptedPlayer != null && !this.canAccess(adaptedPlayer)) {
            return "restricted";
        }
        return "online";
    }

    @Override
    public String getStatus() {
        return this.getStatus(null);
    }

    @Override
    public long getLastSentTime() {
        return System.currentTimeMillis() - this.lastSentTime;
    }

    @Override
    public void setLastSentTime(long l) {
        this.lastSentTime = l;
    }

    @Override
    public boolean isJoinable(AdaptedPlayer adaptedPlayer) {
        AdaptedServer adaptedServer = this.getIdealServer(adaptedPlayer);
        if (adaptedServer == null) {
            return false;
        }
        return adaptedServer.isJoinable(adaptedPlayer) && !this.isPaused();
    }

    @Override
    public synchronized void setPaused(boolean bl) {
        this.paused = bl;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public synchronized void removePlayer(QueuePlayer queuePlayer) {
        this.main.getQueueManager().getSendingAttempts().remove(queuePlayer);
        this.queue.remove(queuePlayer);
        this.positionChange();
    }

    @Override
    public void removePlayer(AdaptedPlayer adaptedPlayer) {
        QueuePlayer queuePlayer = this.findPlayer(adaptedPlayer);
        if (queuePlayer == null) {
            return;
        }
        this.removePlayer(queuePlayer);
    }

    @Override
    public void addPlayer(QueuePlayer queuePlayer) {
        this.addPlayer(queuePlayer, -1);
    }

    @Override
    public synchronized void addPlayer(QueuePlayer queuePlayer, int n) {
        if (!queuePlayer.getQueueServer().equals(this) || this.queue.contains(queuePlayer)) {
            return;
        }
        if (n >= 0) {
            this.queue.add(n, queuePlayer);
        } else {
            this.queue.add(queuePlayer);
        }
        this.positionChange();
    }

    @Override
    public void sendPlayer() {
        this.main.getQueueManager().sendPlayers(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean canAccess(AdaptedPlayer adaptedPlayer) {
        if (adaptedPlayer == null) {
            return true;
        }
        for (AdaptedServer adaptedServer : this.servers) {
            if (!adaptedServer.canAccess(adaptedPlayer)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getAlias() {
        return this.main.getAliasManager().getAlias(this.getName());
    }

    @Override
    public ImmutableList<AdaptedServer> getServers() {
        return ImmutableList.copyOf(this.servers);
    }

    @Override
    public ImmutableList<String> getServerNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AdaptedServer adaptedServer : this.servers) {
            arrayList.add(adaptedServer.getName());
        }
        return ImmutableList.copyOf(arrayList);
    }

    @Override
    public boolean isGroup() {
        return this.servers.size() > 1;
    }

    @Override
    public QueuePlayer findPlayer(String string) {
        for (QueuePlayer queuePlayer : this.queue) {
            if (!queuePlayer.getName().equalsIgnoreCase(string)) continue;
            return queuePlayer;
        }
        return null;
    }

    @Override
    public QueuePlayer findPlayer(AdaptedPlayer adaptedPlayer) {
        return this.findPlayer(adaptedPlayer.getUniqueId());
    }

    @Override
    public synchronized QueuePlayer findPlayer(UUID uUID) {
        for (QueuePlayer queuePlayer : this.queue) {
            if (!queuePlayer.getUniqueId().toString().equals(uUID.toString())) continue;
            return queuePlayer;
        }
        return null;
    }

    @Override
    public AdaptedServer getIdealServer(AdaptedPlayer adaptedPlayer) {
        return this.getBalancer().getIdealServer(adaptedPlayer);
    }

    @Override
    public List<Integer> getSupportedProtocols() {
        return new ArrayList<Integer>(this.supportedProtocols);
    }

    @Override
    public void setSupportedProtocols(List<Integer> list) {
        this.supportedProtocols = new ArrayList<Integer>(list);
    }

    @Override
    public Balancer getBalancer() {
        return this.balancer;
    }

    private void positionChange() {
        this.main.getTaskManager().runNow(() -> this.queue.forEach(queuePlayer -> {
            if (((QueuePlayerImpl)queuePlayer).lastPosition != queuePlayer.getPosition()) {
                this.main.call(new PositionChangeEvent((QueuePlayer)queuePlayer));
            }
        }));
    }
}

