/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common.queues.balancers;

import com.google.common.collect.ImmutableList;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.queues.Balancer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.GenUtils;

public class DefaultBalancer
implements Balancer {
    private final QueueServer server;
    private final QueueMain main;

    public DefaultBalancer(QueueServer queueServer, QueueMain queueMain) {
        this.server = queueServer;
        this.main = queueMain;
    }

    @Override
    public AdaptedServer getIdealServer(AdaptedPlayer adaptedPlayer) {
        ImmutableList<AdaptedServer> immutableList = this.server.getServers();
        AdaptedServer adaptedServer = null;
        int n = 0;
        if (immutableList.size() == 1) {
            adaptedServer = (AdaptedServer)immutableList.get(0);
        } else {
            for (AdaptedServer adaptedServer2 : immutableList) {
                if (!adaptedServer2.isOnline()) continue;
                int n2 = adaptedServer2.getPlayerCount();
                if (adaptedServer == null) {
                    adaptedServer = adaptedServer2;
                    n = n2;
                    continue;
                }
                if (!adaptedServer.isJoinable(adaptedPlayer) && adaptedServer2.isJoinable(adaptedPlayer)) {
                    adaptedServer = adaptedServer2;
                    n = n2;
                    continue;
                }
                if (n <= n2 || !adaptedServer2.isJoinable(adaptedPlayer)) continue;
                adaptedServer = adaptedServer2;
                n = n2;
            }
        }
        if (adaptedServer == null && immutableList.size() > 0) {
            adaptedServer = (AdaptedServer)immutableList.get(0);
        }
        if (adaptedServer == null) {
            this.main.getLogger().warning("Unable to find ideal server, using random server from group.");
            int n3 = GenUtils.randomInt(0, this.server.getServers().size() - 1);
            adaptedServer = (AdaptedServer)this.server.getServers().get(n3);
        }
        return adaptedServer;
    }
}

