/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.bstats.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.slf4j.Logger;
import us.ajg0702.queue.libs.bstats.MetricsBase;
import us.ajg0702.queue.libs.bstats.charts.CustomChart;
import us.ajg0702.queue.libs.bstats.config.MetricsConfig;
import us.ajg0702.queue.libs.bstats.json.JsonObjectBuilder;

public class Metrics {
    private final PluginContainer pluginContainer;
    private final ProxyServer server;
    private MetricsBase metricsBase;

    private Metrics(Object object, ProxyServer proxyServer, Logger logger, Path path, int n) {
        MetricsConfig metricsConfig;
        this.pluginContainer = (PluginContainer)proxyServer.getPluginManager().fromInstance(object).orElseThrow(() -> new IllegalArgumentException("The provided instance is not a plugin"));
        this.server = proxyServer;
        File file = path.getParent().resolve("bStats").resolve("config.txt").toFile();
        try {
            metricsConfig = new MetricsConfig(file, true);
        }
        catch (IOException iOException) {
            logger.error("Failed to create bStats config", (Throwable)iOException);
            return;
        }
        this.metricsBase = new MetricsBase("velocity", metricsConfig.getServerUUID(), n, metricsConfig.isEnabled(), this::appendPlatformData, this::appendServiceData, runnable -> proxyServer.getScheduler().buildTask(object, runnable).schedule(), () -> true, (arg_0, arg_1) -> ((Logger)logger).warn(arg_0, arg_1), arg_0 -> ((Logger)logger).info(arg_0), metricsConfig.isLogErrorsEnabled(), metricsConfig.isLogSentDataEnabled(), metricsConfig.isLogResponseStatusTextEnabled());
        if (!metricsConfig.didExistBefore()) {
            logger.info("Velocity and some of its plugins collect metrics and send them to bStats (https://bStats.org).");
            logger.info("bStats collects some basic information for plugin authors, like how many people use");
            logger.info("their plugin and their total player count. It's recommend to keep bStats enabled, but");
            logger.info("if you're not comfortable with this, you can opt-out by editing the config.txt file in");
            logger.info("the '/plugins/bStats/' folder and setting enabled to false.");
        }
    }

    public void addCustomChart(CustomChart customChart) {
        if (this.metricsBase != null) {
            this.metricsBase.addCustomChart(customChart);
        }
    }

    private void appendPlatformData(JsonObjectBuilder jsonObjectBuilder) {
        jsonObjectBuilder.appendField("playerAmount", this.server.getPlayerCount());
        jsonObjectBuilder.appendField("managedServers", this.server.getAllServers().size());
        jsonObjectBuilder.appendField("onlineMode", this.server.getConfiguration().isOnlineMode() ? 1 : 0);
        jsonObjectBuilder.appendField("velocityVersionVersion", this.server.getVersion().getVersion());
        jsonObjectBuilder.appendField("velocityVersionName", this.server.getVersion().getName());
        jsonObjectBuilder.appendField("velocityVersionVendor", this.server.getVersion().getVendor());
        jsonObjectBuilder.appendField("javaVersion", System.getProperty("java.version"));
        jsonObjectBuilder.appendField("osName", System.getProperty("os.name"));
        jsonObjectBuilder.appendField("osArch", System.getProperty("os.arch"));
        jsonObjectBuilder.appendField("osVersion", System.getProperty("os.version"));
        jsonObjectBuilder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
    }

    private void appendServiceData(JsonObjectBuilder jsonObjectBuilder) {
        jsonObjectBuilder.appendField("pluginVersion", this.pluginContainer.getDescription().getVersion().orElse("unknown"));
    }

    public static class Factory {
        private final ProxyServer server;
        private final Logger logger;
        private final Path dataDirectory;

        @Inject
        private Factory(ProxyServer proxyServer, Logger logger, @DataDirectory Path path) {
            this.server = proxyServer;
            this.logger = logger;
            this.dataDirectory = path;
        }

        public Metrics make(Object object, int n) {
            return new Metrics(object, this.server, this.logger, this.dataDirectory, n);
        }
    }
}

