/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.geantyref;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import us.ajg0702.queue.libs.geantyref.CaptureType;
import us.ajg0702.queue.libs.geantyref.VarMap;

class CaptureTypeImpl
implements CaptureType {
    private final WildcardType wildcard;
    private final TypeVariable<?> variable;
    private final Type[] lowerBounds;
    private Type[] upperBounds;

    CaptureTypeImpl(WildcardType wildcardType, TypeVariable<?> typeVariable) {
        this.wildcard = wildcardType;
        this.variable = typeVariable;
        this.lowerBounds = wildcardType.getLowerBounds();
    }

    void init(VarMap varMap) {
        ArrayList<Type> arrayList = new ArrayList<Type>(Arrays.asList(varMap.map(this.variable.getBounds())));
        List<Type> list = Arrays.asList(this.wildcard.getUpperBounds());
        if (list.size() > 0 && list.get(0) == Object.class) {
            arrayList.addAll(list.subList(1, list.size()));
        } else {
            arrayList.addAll(list);
        }
        this.upperBounds = new Type[arrayList.size()];
        arrayList.toArray(this.upperBounds);
    }

    @Override
    public Type[] getLowerBounds() {
        return (Type[])this.lowerBounds.clone();
    }

    @Override
    public Type[] getUpperBounds() {
        assert (this.upperBounds != null);
        return (Type[])this.upperBounds.clone();
    }

    @Override
    public void setUpperBounds(Type[] typeArray) {
        this.upperBounds = typeArray;
    }

    @Override
    public TypeVariable<?> getTypeVariable() {
        return this.variable;
    }

    @Override
    public WildcardType getWildcardType() {
        return this.wildcard;
    }

    public String toString() {
        return "capture of " + this.wildcard;
    }
}

