/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.geantyref;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import us.ajg0702.queue.libs.geantyref.GenericTypeReflector;

public class TypeVariableImpl<D extends GenericDeclaration>
implements TypeVariable<D> {
    private final Map<Class<? extends Annotation>, Annotation> annotations;
    private final D genericDeclaration;
    private final String name;
    private final AnnotatedType[] bounds;

    TypeVariableImpl(TypeVariable<D> typeVariable, AnnotatedType[] annotatedTypeArray) {
        this(typeVariable, typeVariable.getAnnotations(), annotatedTypeArray);
    }

    TypeVariableImpl(TypeVariable<D> typeVariable, Annotation[] annotationArray, AnnotatedType[] annotatedTypeArray) {
        Objects.requireNonNull(typeVariable);
        this.genericDeclaration = typeVariable.getGenericDeclaration();
        this.name = typeVariable.getName();
        this.annotations = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotationArray) {
            this.annotations.put(annotation.annotationType(), annotation);
        }
        if (annotatedTypeArray == null || annotatedTypeArray.length == 0) {
            throw new IllegalArgumentException("There must be at least one bound. For an unbound variable, the bound must be Object");
        }
        this.bounds = annotatedTypeArray;
    }

    private static AnnotatedType[] annotateBounds(Type[] typeArray) {
        if (typeArray == null || typeArray.length == 0) {
            throw new IllegalArgumentException("There must be at least one bound. For an unbound variable, the bound must be Object");
        }
        return (AnnotatedType[])Arrays.stream(typeArray).map(GenericTypeReflector::annotate).toArray(AnnotatedType[]::new);
    }

    @Override
    public Type[] getBounds() {
        return (Type[])Arrays.stream(this.bounds).map(AnnotatedType::getType).toArray(Type[]::new);
    }

    @Override
    public D getGenericDeclaration() {
        return this.genericDeclaration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AnnotatedType[] getAnnotatedBounds() {
        return this.bounds;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return (T)this.annotations.get(clazz);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations.values().toArray(new Annotation[0]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)object;
            return Objects.equals(this.genericDeclaration, typeVariable.getGenericDeclaration()) && Objects.equals(this.name, typeVariable.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.genericDeclaration.hashCode() ^ this.name.hashCode();
    }

    public String toString() {
        return this.annotationsString() + this.getName();
    }

    private String annotationsString() {
        return this.annotations.isEmpty() ? "" : this.annotations.values().stream().map(Annotation::toString).collect(Collectors.joining(", ")) + " ";
    }
}

