/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.AbstractCommentedConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.AttributedConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationOptions;
import us.ajg0702.queue.libs.sponge.configurate.util.UnmodifiableCollections;

class AttributedConfigurationNodeImpl
extends AbstractCommentedConfigurationNode<AttributedConfigurationNode, AttributedConfigurationNodeImpl>
implements AttributedConfigurationNode {
    private String tagName;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();

    protected AttributedConfigurationNodeImpl(String string, @Nullable Object object, @Nullable AttributedConfigurationNodeImpl attributedConfigurationNodeImpl, ConfigurationOptions configurationOptions) {
        super(object, attributedConfigurationNodeImpl, configurationOptions);
        this.tagName = Objects.requireNonNull(string);
    }

    protected AttributedConfigurationNodeImpl(String string, @Nullable AttributedConfigurationNodeImpl attributedConfigurationNodeImpl, AttributedConfigurationNodeImpl attributedConfigurationNodeImpl2) {
        super(attributedConfigurationNodeImpl, attributedConfigurationNodeImpl2);
        this.tagName = Objects.requireNonNull(string);
    }

    @Override
    public String tagName() {
        return this.tagName;
    }

    @Override
    public AttributedConfigurationNodeImpl tagName(String string) {
        if (Objects.requireNonNull(string, "tag name").isEmpty()) {
            throw new IllegalArgumentException("Tag name cannot be null/empty");
        }
        this.tagName = string;
        return this;
    }

    @Override
    public AttributedConfigurationNodeImpl addAttribute(String string, String string2) {
        if (Objects.requireNonNull(string, "name").isEmpty()) {
            throw new IllegalArgumentException("Attribute name cannot be null/empty");
        }
        this.attachIfNecessary();
        this.attributes.put(string, string2);
        return this;
    }

    @Override
    public AttributedConfigurationNodeImpl removeAttribute(String string) {
        this.attributes.remove(string);
        return this;
    }

    @Override
    public AttributedConfigurationNodeImpl attributes(Map<String, String> map) {
        for (String string : map.keySet()) {
            if (!Objects.requireNonNull(string, "name").isEmpty()) continue;
            throw new IllegalArgumentException("Attribute name cannot be null/empty");
        }
        this.attributes.clear();
        if (!map.isEmpty()) {
            this.attachIfNecessary();
            this.attributes.putAll(map);
        }
        return this;
    }

    @Override
    public Map<String, String> attributes() {
        return UnmodifiableCollections.copyOf(this.attributes);
    }

    @Override
    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    @Override
    public @Nullable String attribute(String string) {
        return this.attributes.get(string);
    }

    @Override
    public boolean empty() {
        return super.empty() && this.attributes.isEmpty();
    }

    @Override
    protected AttributedConfigurationNodeImpl createNode(Object object) {
        return new AttributedConfigurationNodeImpl("element", object, this, this.options());
    }

    @Override
    public AttributedConfigurationNode from(ConfigurationNode configurationNode) {
        if (configurationNode instanceof AttributedConfigurationNode) {
            AttributedConfigurationNode attributedConfigurationNode = (AttributedConfigurationNode)configurationNode;
            this.tagName(attributedConfigurationNode.tagName());
            this.attributes((Map)attributedConfigurationNode.attributes());
        }
        return (AttributedConfigurationNode)super.from(configurationNode);
    }

    @Override
    public AttributedConfigurationNode mergeFrom(ConfigurationNode configurationNode) {
        if (configurationNode instanceof AttributedConfigurationNode) {
            AttributedConfigurationNode attributedConfigurationNode = (AttributedConfigurationNode)configurationNode;
            this.tagName(attributedConfigurationNode.tagName());
            for (Map.Entry<String, String> entry : attributedConfigurationNode.attributes().entrySet()) {
                this.addAttribute(entry.getKey(), entry.getValue());
            }
        }
        return (AttributedConfigurationNode)super.mergeFrom(configurationNode);
    }

    @Override
    protected AttributedConfigurationNodeImpl copy(@Nullable AttributedConfigurationNodeImpl attributedConfigurationNodeImpl) {
        AttributedConfigurationNodeImpl attributedConfigurationNodeImpl2 = new AttributedConfigurationNodeImpl(this.tagName, attributedConfigurationNodeImpl, this);
        attributedConfigurationNodeImpl2.attributes.putAll(this.attributes);
        COMMENT_UPDATER.set(attributedConfigurationNodeImpl2, this.comment);
        return attributedConfigurationNodeImpl2;
    }

    @Override
    public AttributedConfigurationNodeImpl self() {
        return this;
    }

    @Override
    protected AttributedConfigurationNodeImpl implSelf() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AttributedConfigurationNodeImpl)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AttributedConfigurationNodeImpl attributedConfigurationNodeImpl = (AttributedConfigurationNodeImpl)object;
        return this.tagName.equals(attributedConfigurationNodeImpl.tagName) && this.attributes.equals(attributedConfigurationNodeImpl.attributes);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.tagName.hashCode();
        n = 31 * n + this.attributes.hashCode();
        return n;
    }

    @Override
    public String toString() {
        return "AttributedConfigurationNodeImpl{super=" + super.toString() + ", comment=" + this.comment + ", tagName=" + this.tagName + ", attributes=" + this.attributes + '}';
    }
}

