/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.AbstractConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigValue;
import us.ajg0702.queue.libs.sponge.configurate.ScopedConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.serialize.Scalars;
import us.ajg0702.queue.libs.sponge.configurate.util.UnmodifiableCollections;

final class ListConfigValue<N extends ScopedConfigurationNode<N>, A extends AbstractConfigurationNode<N, A>>
implements ConfigValue<N, A> {
    static final AtomicReferenceFieldUpdater<ListConfigValue, List> VALUES_HANDLE = AtomicReferenceFieldUpdater.newUpdater(ListConfigValue.class, List.class, "values");
    static final Object UNALLOCATED_IDX = new Object(){

        public String toString() {
            return "<list unallocated>";
        }
    };
    private final A holder;
    volatile List<A> values = new ArrayList<A>();

    static boolean likelyListKey(@Nullable Object object) {
        return object instanceof Integer || object == UNALLOCATED_IDX;
    }

    ListConfigValue(A a) {
        this.holder = a;
    }

    ListConfigValue(A a, @Nullable Object object) {
        this.holder = a;
        if (object != null) {
            Object a2 = ((AbstractConfigurationNode)a).createNode(0);
            ((AbstractConfigurationNode)a2).attached = true;
            ((AbstractConfigurationNode)a2).raw(object);
            this.values.add(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get() {
        List<A> list;
        List<A> list2 = list = this.values;
        synchronized (list2) {
            ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
            for (AbstractConfigurationNode abstractConfigurationNode : list) {
                arrayList.add(abstractConfigurationNode.raw());
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<N> unwrapped() {
        List<A> list;
        List<A> list2 = list = this.values;
        synchronized (list2) {
            ArrayList arrayList = new ArrayList(list.size());
            for (AbstractConfigurationNode abstractConfigurationNode : list) {
                arrayList.add(abstractConfigurationNode.self());
            }
            return Collections.unmodifiableList(arrayList);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void set(@Nullable Object set) {
        if (!(set instanceof Collection)) {
            set = Collections.singleton(set);
        }
        @Nullable Collection collection = set;
        ArrayList arrayList = new ArrayList(collection.size());
        int n = 0;
        for (Object e : collection) {
            if (e == null) continue;
            Object a = ((AbstractConfigurationNode)this.holder).createNode(n);
            arrayList.add(n, a);
            ((AbstractConfigurationNode)a).attached = true;
            ((AbstractConfigurationNode)a).raw(e);
            ++n;
        }
        this.detachNodes(VALUES_HANDLE.getAndSet(this, arrayList));
    }

    @Override
    public @Nullable A putChild(Object object, @Nullable A a) {
        return this.putChildInternal(object, a, false);
    }

    @Override
    public @Nullable A putChildIfAbsent(Object object, @Nullable A a) {
        return this.putChildInternal(object, a, true);
    }

    private @Nullable A putChildInternal(Object object, @Nullable A a, boolean bl) {
        if (object == UNALLOCATED_IDX) {
            if (a != null) {
                List<A> list;
                do {
                    list = this.values;
                    list.add(a);
                    ((AbstractConfigurationNode)a).key = list.lastIndexOf(a);
                } while (!VALUES_HANDLE.compareAndSet(this, list, list));
            }
            return null;
        }
        return this.putChildInternal((Integer)object, a, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable A putChildInternal(int n, @Nullable A a, boolean bl) {
        List<A> list;
        AbstractConfigurationNode abstractConfigurationNode = null;
        do {
            List<A> list2 = list = this.values;
            synchronized (list2) {
                if (a == null) {
                    if (n >= 0 && n < list.size()) {
                        abstractConfigurationNode = (AbstractConfigurationNode)list.remove(n);
                        for (int i = n; i < list.size(); ++i) {
                            ((AbstractConfigurationNode)list.get((int)i)).key = n;
                        }
                    }
                } else if (n >= 0 && n < list.size()) {
                    if (bl) {
                        return (A)((AbstractConfigurationNode)list.get(n));
                    }
                    abstractConfigurationNode = (AbstractConfigurationNode)list.set(n, a);
                } else {
                    list.add(n, a);
                }
            }
        } while (!VALUES_HANDLE.compareAndSet(this, list, list));
        return (A)abstractConfigurationNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable A child(@Nullable Object object) {
        List<A> list;
        @Nullable Integer n = Scalars.INTEGER.tryDeserialize(object);
        if (n == null || n < 0) {
            return null;
        }
        List<A> list2 = list = this.values;
        synchronized (list2) {
            if (n >= list.size()) {
                return null;
            }
            return (A)((AbstractConfigurationNode)list.get(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<A> iterateChildren() {
        List<A> list;
        List<A> list2 = list = this.values;
        synchronized (list2) {
            return UnmodifiableCollections.copyOf(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConfigValue<N, A> copy(A a) {
        ArrayList<A> arrayList;
        List<A> list;
        ListConfigValue<N, A> listConfigValue = new ListConfigValue<N, A>(a);
        List<A> list2 = list = this.values;
        synchronized (list2) {
            arrayList = new ArrayList<A>(list.size());
            for (AbstractConfigurationNode abstractConfigurationNode : list) {
                arrayList.add(abstractConfigurationNode.copy(a));
            }
        }
        listConfigValue.values = arrayList;
        return listConfigValue;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachNodes(List<? extends AbstractConfigurationNode<?, ?>> list) {
        List<AbstractConfigurationNode<?, ?>> list2 = list;
        synchronized (list2) {
            for (AbstractConfigurationNode<?, ?> abstractConfigurationNode : list) {
                abstractConfigurationNode.attached = false;
                if (!Objects.equals(abstractConfigurationNode.parent(), this.holder)) continue;
                abstractConfigurationNode.clear();
            }
        }
    }

    @Override
    public void clear() {
        List list = VALUES_HANDLE.getAndSet(this, new ArrayList());
        this.detachNodes(list);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ListConfigValue)) {
            return false;
        }
        ListConfigValue listConfigValue = (ListConfigValue)object;
        return Objects.equals(this.values, listConfigValue.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return "ListConfigValue{values=" + this.values.toString() + '}';
    }
}

