/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.AbstractConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigValue;
import us.ajg0702.queue.libs.sponge.configurate.ScopedConfigurationNode;

final class MapConfigValue<N extends ScopedConfigurationNode<N>, A extends AbstractConfigurationNode<N, A>>
implements ConfigValue<N, A> {
    private final A holder;
    volatile Map<Object, A> values;

    MapConfigValue(A a) {
        this.holder = a;
        this.values = this.newMap();
    }

    private Map<Object, A> newMap() {
        Map map = ((AbstractConfigurationNode)this.holder).options().mapFactory().create();
        if (!(map instanceof ConcurrentMap)) {
            return Collections.synchronizedMap(map);
        }
        return map;
    }

    @Override
    public Object get() {
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
        for (Map.Entry<Object, A> entry : this.values.entrySet()) {
            linkedHashMap.put(entry.getKey(), ((AbstractConfigurationNode)entry.getValue()).raw());
        }
        return linkedHashMap;
    }

    public Map<Object, N> unwrapped() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.values.forEach((object, abstractConfigurationNode) -> linkedHashMap.put(object, abstractConfigurationNode.self()));
        return Collections.unmodifiableMap(linkedHashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(@Nullable Object object) {
        if (object instanceof Map) {
            Map<Object, A> map = this.newMap();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (entry.getValue() == null) continue;
                Object a = ((AbstractConfigurationNode)this.holder).createNode(entry.getKey());
                map.put(entry.getKey(), a);
                ((AbstractConfigurationNode)a).attached = true;
                ((AbstractConfigurationNode)a).raw(entry.getValue());
            }
            MapConfigValue mapConfigValue = this;
            synchronized (mapConfigValue) {
                Map.Entry entry;
                entry = this.values;
                this.values = map;
                this.detachChildren((Map<Object, ? extends AbstractConfigurationNode<?, ?>>)((Object)entry));
            }
        } else {
            throw new IllegalArgumentException("Map configuration values can only be set to values of type Map");
        }
    }

    @Override
    public @Nullable A putChild(Object object, @Nullable A a) {
        if (a == null) {
            return (A)((AbstractConfigurationNode)this.values.remove(object));
        }
        return (A)((AbstractConfigurationNode)this.values.put(object, a));
    }

    @Override
    public @Nullable A putChildIfAbsent(Object object, @Nullable A a) {
        if (a == null) {
            return (A)((AbstractConfigurationNode)this.values.remove(object));
        }
        return (A)((AbstractConfigurationNode)this.values.putIfAbsent(object, a));
    }

    @Override
    public @Nullable A child(@Nullable Object object) {
        return (A)((AbstractConfigurationNode)this.values.get(object));
    }

    @Override
    public Iterable<A> iterateChildren() {
        return this.values.values();
    }

    @Override
    public MapConfigValue<N, A> copy(A a) {
        MapConfigValue<N, A> mapConfigValue = new MapConfigValue<N, A>(a);
        for (Map.Entry<Object, A> entry : this.values.entrySet()) {
            mapConfigValue.values.put(entry.getKey(), ((AbstractConfigurationNode)entry.getValue()).copy(a));
        }
        return mapConfigValue;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    private void detachChildren(Map<Object, ? extends AbstractConfigurationNode<?, ?>> map) {
        for (AbstractConfigurationNode<?, ?> abstractConfigurationNode : map.values()) {
            abstractConfigurationNode.attached = false;
            if (!Objects.equals(abstractConfigurationNode.parent(), this.holder)) continue;
            abstractConfigurationNode.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        MapConfigValue mapConfigValue = this;
        synchronized (mapConfigValue) {
            Map<Object, A> map = this.values;
            this.values = this.newMap();
            this.detachChildren(map);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MapConfigValue)) {
            return false;
        }
        MapConfigValue mapConfigValue = (MapConfigValue)object;
        return Objects.equals(this.values, mapConfigValue.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return "MapConfigValue{values=" + this.values + '}';
    }
}

