/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.loader;

import java.io.BufferedWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;

public final class AtomicFiles {
    private static final int MAX_TRIES = 2;

    private AtomicFiles() {
    }

    public static Callable<BufferedWriter> atomicWriterFactory(Path path, Charset charset) {
        Objects.requireNonNull(path, "path");
        return () -> AtomicFiles.atomicBufferedWriter(path, charset);
    }

    public static BufferedWriter atomicBufferedWriter(Path path, Charset charset) {
        path = path.toAbsolutePath();
        try {
            while (Files.isSymbolicLink(path)) {
                path = Files.readSymbolicLink(path);
            }
        }
        catch (IOException | UnsupportedOperationException exception) {
            // empty catch block
        }
        Path path2 = AtomicFiles.temporaryPath(path.getParent(), path.getFileName().toString());
        if (Files.exists(path, new LinkOption[0])) {
            Files.copy(path, path2, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
        AtomicFiles.createDirectoriesIfNecessary(path2.getParent());
        BufferedWriter bufferedWriter = Files.newBufferedWriter(path2, charset, new OpenOption[0]);
        return new BufferedWriter(new AtomicFileWriter(path2, path, bufferedWriter));
    }

    private static void createDirectoriesIfNecessary(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    private static Path temporaryPath(Path path, String string) {
        String string2 = "." + System.nanoTime() + ThreadLocalRandom.current().nextInt() + Objects.requireNonNull(string, "key").replaceAll("[\\\\/:]", "-") + ".tmp";
        return path.resolve(string2);
    }

    private static class AtomicFileWriter
    extends FilterWriter {
        private final Path targetPath;
        private final Path writePath;

        protected AtomicFileWriter(Path path, Path path2, Writer writer) {
            super(writer);
            this.writePath = path;
            this.targetPath = path2;
        }

        @Override
        public void close() {
            super.close();
            try {
                Files.move(this.writePath, this.targetPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AccessDeniedException accessDeniedException) {
                for (int i = 0; i < 2; ++i) {
                    try {
                        Thread.sleep(5 * i);
                        Files.move(this.writePath, this.targetPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    catch (AccessDeniedException accessDeniedException2) {
                        if (i != 1) continue;
                        throw accessDeniedException;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        throw accessDeniedException;
                    }
                }
            }
        }
    }
}

