/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.loader;

import com.google.errorprone.annotations.Immutable;
import java.io.BufferedReader;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.loader.CommentHandler;
import us.ajg0702.queue.libs.sponge.configurate.util.Strings;

@Immutable
public enum CommentHandlers implements CommentHandler
{
    HASH(new AbstractPrefixHandler("#")),
    DOUBLE_SLASH(new AbstractPrefixHandler("//")),
    SLASH_BLOCK(new AbstractDelineatedHandler("/*", "*/", "*")),
    XML_STYLE(new AbstractDelineatedHandler("<!--", "-->", "~"));

    private static final int READAHEAD_LEN = 4096;
    private final CommentHandler delegate;

    private CommentHandlers(CommentHandler commentHandler) {
        this.delegate = commentHandler;
    }

    @Override
    public @Nullable String extractHeader(BufferedReader bufferedReader) {
        return this.delegate.extractHeader(bufferedReader);
    }

    @Override
    public Stream<String> toComment(Stream<String> stream) {
        return this.delegate.toComment(stream);
    }

    public static @Nullable String extractComment(BufferedReader bufferedReader, Iterable<CommentHandler> iterable) {
        bufferedReader.mark(4096);
        for (CommentHandler commentHandler : iterable) {
            @Nullable String string = commentHandler.extractHeader(bufferedReader);
            if (string == null) {
                bufferedReader.reset();
                continue;
            }
            return string;
        }
        return null;
    }

    static boolean beginsWithPrefix(String string, BufferedReader bufferedReader) {
        CharBuffer charBuffer = CharBuffer.allocate(string.length());
        if (bufferedReader.read(charBuffer) != charBuffer.limit()) {
            return false;
        }
        charBuffer.flip();
        return string.contentEquals(charBuffer);
    }

    @Immutable
    private static final class AbstractPrefixHandler
    implements CommentHandler {
        private final String commentPrefix;

        AbstractPrefixHandler(String string) {
            this.commentPrefix = string;
        }

        @Override
        public @Nullable String extractHeader(BufferedReader bufferedReader) {
            if (!CommentHandlers.beginsWithPrefix(this.commentPrefix, bufferedReader)) {
                return null;
            }
            boolean bl = true;
            StringBuilder stringBuilder = new StringBuilder();
            String string = bufferedReader.readLine();
            while (string != null) {
                if (bl) {
                    if (string.length() > 0 && string.charAt(0) == ' ') {
                        string = string.substring(1);
                    }
                    stringBuilder.append(string);
                    bl = false;
                } else if (string.trim().startsWith(this.commentPrefix)) {
                    if ((string = string.substring(string.indexOf(this.commentPrefix) + 1)).length() > 0 && string.charAt(0) == ' ') {
                        string = string.substring(1);
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(string);
                } else {
                    if (Strings.isBlank(string)) break;
                    return null;
                }
                string = bufferedReader.readLine();
            }
            return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
        }

        @Override
        public Stream<String> toComment(Stream<String> stream) {
            return stream.map(string -> {
                if (string.length() > 0 && string.charAt(0) == ' ') {
                    return this.commentPrefix + string;
                }
                return this.commentPrefix + " " + string;
            });
        }
    }

    @Immutable
    private static final class AbstractDelineatedHandler
    implements CommentHandler {
        private final String startSequence;
        private final String endSequence;
        private final String lineIndentSequence;

        private AbstractDelineatedHandler(String string, String string2, String string3) {
            this.startSequence = string;
            this.endSequence = string2;
            this.lineIndentSequence = string3;
        }

        @Override
        public @Nullable String extractHeader(BufferedReader bufferedReader) {
            if (!CommentHandlers.beginsWithPrefix(this.startSequence, bufferedReader)) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = bufferedReader.readLine();
            if (string == null) {
                return null;
            }
            if (this.handleSingleLine(stringBuilder, string)) {
                string = bufferedReader.readLine();
                while (string != null && this.handleSingleLine(stringBuilder, string)) {
                    string = bufferedReader.readLine();
                }
            }
            if ((string = bufferedReader.readLine()) != null && !string.trim().isEmpty()) {
                return null;
            }
            if (stringBuilder.length() > 0) {
                return stringBuilder.toString();
            }
            return null;
        }

        private boolean handleSingleLine(StringBuilder stringBuilder, String string) {
            boolean bl = true;
            if (string.trim().endsWith(this.endSequence)) {
                if ((string = string.substring(0, string.lastIndexOf(this.endSequence))).endsWith(" ")) {
                    string = string.substring(0, string.length() - 1);
                }
                bl = false;
                if (string.isEmpty()) {
                    return false;
                }
            }
            if (string.trim().startsWith(this.lineIndentSequence)) {
                string = string.substring(string.indexOf(this.lineIndentSequence) + 1);
            }
            if (string.length() > 0 && string.charAt(0) == ' ') {
                string = string.substring(1);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(string.replace("\r", "").replace("\n", "").replace("\r\n", ""));
            return bl;
        }

        @Override
        public Stream<String> toComment(Stream<String> stream) {
            Stream.Builder<String> builder = Stream.builder();
            boolean bl = true;
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (bl) {
                    if (!iterator.hasNext()) {
                        builder.add(this.startSequence + " " + string + " " + this.endSequence);
                        return builder.build();
                    }
                    builder.add(this.startSequence);
                    bl = false;
                }
                builder.add(" " + this.lineIndentSequence + " " + string);
            }
            builder.add(" " + this.endSequence);
            return builder.build();
        }
    }
}

