/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.reactive;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Disposable;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Publisher;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Subscriber;
import us.ajg0702.queue.libs.sponge.configurate.util.CheckedSupplier;

class ExecutePublisher<V>
implements Publisher<V> {
    private final CompletableFuture<V> actor = new CompletableFuture();
    private final Executor executor;

    ExecutePublisher(CheckedSupplier<V, ? extends Exception> checkedSupplier, Executor executor) {
        executor.execute(() -> {
            try {
                this.actor.complete(checkedSupplier.get());
            }
            catch (Exception exception) {
                this.actor.completeExceptionally(exception);
            }
        });
        this.executor = executor;
    }

    @Override
    public Disposable subscribe(Subscriber<? super V> subscriber) {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        ((CompletableFuture)this.actor.whenCompleteAsync((object, throwable) -> {
            if (atomicBoolean.compareAndSet(true, false)) {
                if (throwable != null) {
                    subscriber.onError((Throwable)throwable);
                } else {
                    try {
                        subscriber.submit(object);
                        subscriber.onClose();
                    }
                    catch (Exception exception) {
                        subscriber.onError(exception);
                    }
                }
            }
        }, this.executor)).exceptionally(throwable -> {
            throw new Error((Throwable)throwable);
        });
        return () -> atomicBoolean.set(false);
    }

    @Override
    public boolean hasSubscribers() {
        return !this.actor.isDone() && this.actor.getNumberOfDependents() > 0;
    }

    @Override
    public Executor executor() {
        return this.executor;
    }
}

